#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,87,149,211,273,397,521,645,769,893,955,1018,1142,1266,1515,1577,1639,1763,1825,1887,2012,3006,3254,3503,4000
 * N : 25,87,149,211,273,397,521,645,769,893,955,1018,1142,1266,1515,1577,1639,1763,1825,1887,2012,3006,3254,3503,4000
 * NB : 12,12,20,36,36,36,48,48,52,64,64,68,68,80,80,104,108,108,108,124,124,152,152,156,164
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 118) (nb_) = 12; \
   else if ((n_) < 180) (nb_) = 20; \
   else if ((n_) < 459) (nb_) = 36; \
   else if ((n_) < 707) (nb_) = 48; \
   else if ((n_) < 831) (nb_) = 52; \
   else if ((n_) < 986) (nb_) = 64; \
   else if ((n_) < 1204) (nb_) = 68; \
   else if ((n_) < 1546) (nb_) = 80; \
   else if ((n_) < 1608) (nb_) = 104; \
   else if ((n_) < 1856) (nb_) = 108; \
   else if ((n_) < 2509) (nb_) = 124; \
   else if ((n_) < 3378) (nb_) = 152; \
   else if ((n_) < 3751) (nb_) = 156; \
   else (nb_) = 164; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
