## RabbitMQ 3.6.9

RabbitMQ `3.6.9` is a security and maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

This release has no incompatibilities with 3.6.7. See [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7)
upgrade and compatibility notes if upgrading from an earlier release.


### Management and Management Agent Plugins

#### Security Vulnerability Patches

Details for the CVEs below are pending publication.

 * `CVE-2017-4965`: XSS vulnerabilities in management UI
 * `CVE-2017-4966`: authentication details are stored in browser-local storage without expiration
 * `CVE-2017-4967`: XSS vulnerabilities in management UI

As part of the patch addressing `CVE-2017-4966` management UI sessions were limited to 8 hours.

#### Bug Fixes

 * Certain TCP and TLS listener configuration settings could break JSON serialisation of
   `GET /api/overview` responses.
 
   GitHub issues: [rabbitmq-management-agent#39](https://github.com/rabbitmq/rabbitmq-management-agent/issues/39),
                  [rabbitmq-management#364](https://github.com/rabbitmq/rabbitmq-management/issues/364),
                  [rabbitmq-management-agent#36](https://github.com/rabbitmq/rabbitmq-management-agent/issues/36)

### Federation Plugin

#### Bug Fixes

 * More numerical types are now handled for the "hops" property.
 
   GitHub issue: [rabbitmq-federation#56](https://github.com/rabbitmq/rabbitmq-federation/issues/56)


### .NET Client

#### Bug Fixes

 * Calling ExchangeBind more than once with the same arguments threw an exception.
 
   GitHub issues: [rabbitmq-dotnet-client#314](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/314),
                  [rabbitmq-dotnet-client#317](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/317)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.9.tar.gz`.
