/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.nlogo.api.ExtensionException;

class ColorSchemesComboBox
extends JComboBox<ImageIcon> {
    private static final long serialVersionUID = 1L;
    DefaultComboBoxModel<ImageIcon> sequentialSchemeModel;
    DefaultComboBoxModel<ImageIcon> qualitativeSchemeModel;
    DefaultComboBoxModel<ImageIcon> divergentSchemeModel;
    final String[] schemeType = new String[]{"Sequential", "Divergent", "Qualitative"};
    String selectedScheme = "Sequential";
    String[] sequentialSchemeStrings;
    String[] divergentSchemeStrings;
    String[] qualitativeSchemeStrings;
    ImageIcon[] sequentialSchemeImages;
    ImageIcon[] divergentSchemeImages;
    ImageIcon[] qualitativeSchemeImages;
    ColorSchemesPanel colorSchemesWidget;

    public ColorSchemesComboBox(String ColorSchemeString, ColorSchemesPanel parent) {
        this.colorSchemesWidget = parent;
        this.sequentialSchemeStrings = this.populateSchemeString(Sequential.class);
        this.sequentialSchemeImages = this.populateSchemeImage(Sequential.class);
        this.sequentialSchemeModel = new DefaultComboBoxModel<ImageIcon>(this.sequentialSchemeImages);
        this.divergentSchemeStrings = this.populateSchemeString(Divergent.class);
        this.divergentSchemeImages = this.populateSchemeImage(Divergent.class);
        this.divergentSchemeModel = new DefaultComboBoxModel<ImageIcon>(this.divergentSchemeImages);
        this.qualitativeSchemeStrings = this.populateSchemeString(Qualitative.class);
        this.qualitativeSchemeImages = this.populateSchemeImage(Qualitative.class);
        this.qualitativeSchemeModel = new DefaultComboBoxModel<ImageIcon>(this.qualitativeSchemeImages);
        this.addActionListener(this);
        this.setRenderer(new ComboBoxRenderer());
        this.setMaximumRowCount(17);
        this.setModelFromString(ColorSchemeString);
    }

    public void setModelFromString(String ColorSchemeString) {
        if (ColorSchemeString == "Sequential") {
            this.setModel(this.sequentialSchemeModel);
        }
        if (ColorSchemeString == "Divergent") {
            this.setModel(this.divergentSchemeModel);
        }
        if (ColorSchemeString == "Qualitative") {
            this.setModel(this.qualitativeSchemeModel);
        }
    }

    public String[] populateSchemeString(Class<? extends ColorSchemes> c) {
        Field[] SchemeFields = c.getDeclaredFields();
        String[] s = new String[SchemeFields.length];
        for (int i = 0; i < SchemeFields.length; ++i) {
            s[i] = SchemeFields[i].getName();
        }
        return s;
    }

    public ImageIcon[] populateSchemeImage(Class<? extends ColorSchemes> c) {
        Field[] schemeFields = c.getDeclaredFields();
        ImageIcon[] legends = new ImageIcon[schemeFields.length];
        for (int i = 0; i < schemeFields.length; ++i) {
            String fieldName = schemeFields[i].getName();
            int[][] legend = null;
            try {
                legend = ColorSchemes.getRGBArray(c.getName(), fieldName, 5);
            }
            catch (ExtensionException extensionException) {
                // empty catch block
            }
            legends[i] = new ColorSchemesIconImage(legend, 20);
            legends[i].setDescription(fieldName);
        }
        return legends;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<ImageIcon> {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ImageIcon> list, ImageIcon icon, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(icon.getDescription());
            this.setIcon(icon);
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            boolean legendExist = false;
            try {
                legendExist = ColorSchemesComboBox.this.colorSchemesWidget.legendExists(icon.getDescription());
            }
            catch (ExtensionException ex) {
                this.setEnabled(legendExist);
            }
            if (isSelected && legendExist) {
                this.setBackground(list.getBackground());
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
                try {
                    ColorSchemesComboBox.this.colorSchemesWidget.displayLegend(icon.getDescription());
                }
                catch (ExtensionException extensionException) {
                    // empty catch block
                }
                this.setEnabled(legendExist);
            } else {
                this.setBackground(list.getBackground());
                this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            return this;
        }
    }
}

