/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.primitives;

import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.Reporter;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.core.SyntaxJ$;
import org.nlogo.extensions.time.PeriodType;
import org.nlogo.extensions.time.TimeExtension$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.datatypes.LogoTime;
import org.nlogo.nvm.ExtensionContext;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ut!B\u001a5\u0011\u0003yd!B!5\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Qe\u0001B&\u0002\u00011CQ!S\u0002\u0005\u0002MCQAV\u0002\u0005\u0002]CQAX\u0002\u0005\u0002}3A!\\\u0001\u0001]\")\u0011j\u0002C\u0001_\")ak\u0002C\u0001/\")al\u0002C\u0001c\u001a!A/\u0001\u0001v\u0011\u0015I5\u0002\"\u0001w\u0011\u001516\u0002\"\u0001X\u0011\u0015q6\u0002\"\u0001y\r\u0011Y\u0018\u0001\u0001?\t\u000b%{A\u0011A?\t\u000bY{A\u0011A,\t\u000by{A\u0011A@\u0007\r\u0005\u0015\u0011\u0001AA\u0004\u0011\u0019I5\u0003\"\u0001\u0002\n!)ak\u0005C\u0001/\"1al\u0005C\u0001\u0003\u001b1a!a\u0005\u0002\u0001\u0005U\u0001BB%\u0018\t\u0003\t9\u0002C\u0003W/\u0011\u0005q\u000b\u0003\u0004_/\u0011\u0005\u00111\u0004\u0004\u0007\u0003C\t\u0001!a\t\t\r%[B\u0011AA\u0013\u0011\u001516\u0004\"\u0001X\u0011\u0019q6\u0004\"\u0001\u0002*\u00191\u0011qF\u0001\u0001\u0003cAa!S\u0010\u0005\u0002\u0005M\u0002\"\u0002, \t\u00039\u0006B\u00020 \t\u0003\t9D\u0002\u0004\u0002>\u0005\u0001\u0011q\b\u0005\u0007\u0013\u000e\"\t!!\u0011\t\u000bY\u001bC\u0011A,\t\ry\u001bC\u0011AA#\r\u0019\tY%\u0001\u0001\u0002N!1\u0011j\nC\u0001\u0003\u001fBQAV\u0014\u0005\u0002]CaAX\u0014\u0005\u0002\u0005McABA-\u0003\u0001\tY\u0006\u0003\u0004JW\u0011\u0005\u0011Q\f\u0005\u0006-.\"\ta\u0016\u0005\u0007=.\"\t!!\u0019\u0007\r\u0005\u001d\u0014\u0001AA5\u0011\u0019Iu\u0006\"\u0001\u0002l!)ak\fC\u0001/\"1al\fC\u0001\u0003_\na\u0002V5nKB\u0013\u0018.\\5uSZ,7O\u0003\u00026m\u0005Q\u0001O]5nSRLg/Z:\u000b\u0005]B\u0014\u0001\u0002;j[\u0016T!!\u000f\u001e\u0002\u0015\u0015DH/\u001a8tS>t7O\u0003\u0002<y\u0005)a\u000e\\8h_*\tQ(A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002A\u00035\tAG\u0001\bUS6,\u0007K]5nSRLg/Z:\u0014\u0005\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007f\tYa*Z<M_\u001e|G+[7f'\r\u00191)\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!j\n1!\u00199j\u0013\t\u0011vJ\u0001\u0005SKB|'\u000f^3s)\u0005!\u0006CA+\u0004\u001b\u0005\t\u0011!C4fiNKh\u000e^1y)\u0005A\u0006CA-]\u001b\u0005Q&BA.;\u0003\u0011\u0019wN]3\n\u0005uS&AB*z]R\f\u00070\u0001\u0004sKB|'\u000f\u001e\u000b\u0004\u0007\u0002D\u0007\"B1\u0007\u0001\u0004\u0011\u0017\u0001B1sON\u00042\u0001R2f\u0013\t!WIA\u0003BeJ\f\u0017\u0010\u0005\u0002OM&\u0011qm\u0014\u0002\t\u0003J<W/\\3oi\")\u0011N\u0002a\u0001U\u000691m\u001c8uKb$\bC\u0001(l\u0013\tawJA\u0004D_:$X\r\u001f;\u0003\r\u0005s7\r[8s'\r91)\u0014\u000b\u0002aB\u0011Qk\u0002\u000b\u0004\u0007J\u001c\b\"B1\u000b\u0001\u0004\u0011\u0007\"B5\u000b\u0001\u0004Q'\u0001B*i_^\u001c2aC\"N)\u00059\bCA+\f)\r\u0019\u0015P\u001f\u0005\u0006C:\u0001\rA\u0019\u0005\u0006S:\u0001\rA\u001b\u0002\u0005\u0007>\u0004\u0018pE\u0002\u0010\u00076#\u0012A \t\u0003+>!RaQA\u0001\u0003\u0007AQ!\u0019\nA\u0002\tDQ!\u001b\nA\u0002)\u0014\u0001c\u0011:fCR,w+\u001b;i\r>\u0014X.\u0019;\u0014\u0007M\u0019U\n\u0006\u0002\u0002\fA\u0011Qk\u0005\u000b\u0006\u0007\u0006=\u0011\u0011\u0003\u0005\u0006CZ\u0001\rA\u0019\u0005\u0006SZ\u0001\rA\u001b\u0002\u0012\t&4g-\u001a:f]\u000e,')\u001a;xK\u0016t7cA\fD\u001bR\u0011\u0011\u0011\u0004\t\u0003+^!RaQA\u000f\u0003?AQ!\u0019\u000eA\u0002\tDQ!\u001b\u000eA\u0002)\u00141aR3u'\rY2)\u0014\u000b\u0003\u0003O\u0001\"!V\u000e\u0015\u000b\r\u000bY#!\f\t\u000b\u0005t\u0002\u0019\u00012\t\u000b%t\u0002\u0019\u00016\u0003\u000f%\u001b\u0018I\u001a;feN\u0019qdQ'\u0015\u0005\u0005U\u0002CA+ )\u0015\u0019\u0015\u0011HA\u001e\u0011\u0015\t'\u00051\u0001c\u0011\u0015I'\u00051\u0001k\u0005!I5OQ3g_J,7cA\u0012D\u001bR\u0011\u00111\t\t\u0003+\u000e\"RaQA$\u0003\u0013BQ!\u0019\u0014A\u0002\tDQ!\u001b\u0014A\u0002)\u0014\u0011\"S:CKR<X-\u001a8\u0014\u0007\u001d\u001aU\n\u0006\u0002\u0002RA\u0011Qk\n\u000b\u0006\u0007\u0006U\u0013q\u000b\u0005\u0006C*\u0002\rA\u0019\u0005\u0006S*\u0002\rA\u001b\u0002\b\u0013N,\u0015/^1m'\rY3)\u0014\u000b\u0003\u0003?\u0002\"!V\u0016\u0015\u000b\r\u000b\u0019'!\u001a\t\u000b\u0005t\u0003\u0019\u00012\t\u000b%t\u0003\u0019\u00016\u0003\tAcWo]\n\u0004_\rkECAA7!\t)v\u0006F\u0003D\u0003c\n\u0019\bC\u0003be\u0001\u0007!\rC\u0003je\u0001\u0007!\u000e")
public final class TimePrimitives {

    public static class Anchor
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.NumberType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        /*
         * WARNING - void declaration
         */
        public Object report(Argument[] args, Context context) {
            void var3_3;
            LogoTime newTime = new LogoTime(TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0)));
            newTime.setAnchor(TimeUtils$.MODULE$.getDoubleFromArgument(args, Predef$.MODULE$.int2Integer(1)), TimeUtils$.MODULE$.stringToPeriodType(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2))), ((ExtensionContext)context).workspace().world());
            return var3_3;
        }
    }

    public static class Copy
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            return new LogoTime(time);
        }
    }

    public static class CreateWithFormat
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.StringType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            TimeExtension$.MODULE$.context_$eq(context);
            String string = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            Object object = string == null ? None$.MODULE$ : new Some((Object)string);
            None$ customFormat = object;
            return new LogoTime(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0)), (Option<String>)customFormat);
        }
    }

    public static class DifferenceBetween
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.NumberType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime startTime = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoTime endTime = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
            PeriodType pType = TimeUtils$.MODULE$.stringToPeriodType(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2)));
            return startTime.getDifferenceBetween(pType, endTime);
        }
    }

    public static class Get
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.StringType(), Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.NumberType());
        }

        public Object report(Argument[] args, Context context) {
            PeriodType periodType = TimeUtils$.MODULE$.stringToPeriodType(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0)));
            LogoTime time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
            return BoxesRunTime.boxToDouble((double)time.get(periodType));
        }
    }

    public static class IsAfter
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.BooleanType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime timeB;
            LogoTime timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            return BoxesRunTime.boxToBoolean((!timeA.isBefore(timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1))) && !timeA.isEqual(timeB) ? 1 : 0) != 0);
        }
    }

    public static class IsBefore
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.BooleanType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoTime timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
            return BoxesRunTime.boxToBoolean((boolean)timeA.isBefore(timeB));
        }
    }

    public static class IsBetween
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.BooleanType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoTime timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
            LogoTime timeC = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(2));
            return BoxesRunTime.boxToBoolean((boolean)timeA.isBetween(timeB, timeC));
        }
    }

    public static class IsEqual
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.BooleanType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoTime timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
            return BoxesRunTime.boxToBoolean((boolean)timeA.isEqual(timeB));
        }
    }

    public static class NewLogoTime
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            TimeExtension$.MODULE$.context_$eq(context);
            return new LogoTime(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0)));
        }
    }

    public static class Plus
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.NumberType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime time = new LogoTime(TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0)));
            return time.plus(TimeUtils$.MODULE$.stringToPeriodType(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2))), TimeUtils$.MODULE$.getDoubleFromArgument(args, Predef$.MODULE$.int2Integer(1)));
        }
    }

    public static class Show
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.StringType());
        }

        public Object report(Argument[] args, Context context) {
            LogoTime time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(0));
            String fmtString = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            String string = fmtString.trim();
            String string2 = "";
            DateTimeFormatter fmt = !(string != null ? !string.equals(string2) : string2 != null) ? DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS").withResolverStyle(ResolverStyle.STRICT) : DateTimeFormatter.ofPattern(fmtString.replace('y', 'u')).withResolverStyle(ResolverStyle.STRICT);
            return time.show(fmt);
        }
    }
}

