/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.datatypes;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import org.nlogo.agent.World;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.extensions.time.Date$;
import org.nlogo.extensions.time.DateTime$;
import org.nlogo.extensions.time.DateType;
import org.nlogo.extensions.time.Day$;
import org.nlogo.extensions.time.DayDate$;
import org.nlogo.extensions.time.DayOfWeek$;
import org.nlogo.extensions.time.DayOfYear$;
import org.nlogo.extensions.time.Hour$;
import org.nlogo.extensions.time.Milli$;
import org.nlogo.extensions.time.Minute$;
import org.nlogo.extensions.time.Month$;
import org.nlogo.extensions.time.PeriodType;
import org.nlogo.extensions.time.Second$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.Week$;
import org.nlogo.extensions.time.Year$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001B#G\u0001ECQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001A\u0002\u0013\u00051\rC\u0004i\u0001\u0001\u0007I\u0011A5\t\r=\u0004\u0001\u0015)\u0003e\u0011\u001d\u0001\b\u00011A\u0005\u0002EDq!\u001f\u0001A\u0002\u0013\u0005!\u0010\u0003\u0004}\u0001\u0001\u0006KA\u001d\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011%\t)\u0001\u0001a\u0001\n\u0003\t9\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B@\t\u0013\u00055\u0001\u00011A\u0005\u0002\u0005=\u0001\"CA\f\u0001\u0001\u0007I\u0011AA\r\u0011!\ti\u0002\u0001Q!\n\u0005E\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004\u0003\u0005\u00026\u0001\u0001\u000b\u0015BA\u0012\u0011%\t9\u0004\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0002:\u0001\u0001\r\u0011\"\u0003\u0002<!A\u0011q\b\u0001!B\u0013\t\u0019\u0003C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D!I\u0011\u0011\u000b\u0001A\u0002\u0013%\u00111\u000b\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002F!Y\u0011\u0011\f\u0001A\u0002\u0003\u0007I\u0011BA.\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\t\u0017\u0005%\u0004\u00011A\u0001B\u0003&\u0011Q\f\u0005\f\u0003W\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0007C\u0006\u0002v\u0001\u0001\r\u00111A\u0005\n\u0005]\u0004bCA>\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_B!\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0011-\ty\b\u0001a\u0001\u0002\u0004%I!!!\t\u0015\u0005\u0015\u0005\u00011A\u0001B\u0003&!\u000f\u0003\u0006\u0002\b\u0002\u0001\r\u00111A\u0005\nyD1\"!#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f\"Q\u0011q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u0017\u0005E\u0005\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u0003'\u0003\u0001\u0019!a\u0001\n\u0013\t)\nC\u0006\u0002\u001a\u0002\u0001\r\u0011!Q!\n\u0005E\u0001bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"a+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0005\u000b\u0015BAP\u0011\u0019q\u0006\u0001\"\u0001\u00024\"1a\f\u0001C\u0001\u00053AaA\u0018\u0001\u0005\u0002\tU\u0002B\u00020\u0001\t\u0003\u0011Y\u0004\u0003\u0004_\u0001\u0011\u0005!q\t\u0005\u0007=\u0002!\tAa\u0013\t\ry\u0003A\u0011\u0001B(\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003n\u0001!\tAa\u001c\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\"9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BP\u0001\u0011\u0005!\u0011\u0015\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u0011i\f\u0001C\u0001\u0005\u007fCqA!5\u0001\t\u0003\u0012\u0019\u000eC\u0004\u0003V\u0002!\tAa6\t\u000f\te\u0007\u0001\"\u0001\u0003T\"9!1\u001c\u0001\u0005\u0002\tM\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\b\u0005K\u0004A\u0011\u0001Bt\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_DqA!>\u0001\t\u0003\u00119\u0010C\u0004\u0003v\u0002!\ta!\u0001\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!911\u0003\u0001\u0005\u0002\rU\u0001bBB\r\u0001\u0011\u000511\u0004\u0005\b\u0007K\u0001A\u0011AB\u0014\u0005!aunZ8US6,'BA$I\u0003%!\u0017\r^1usB,7O\u0003\u0002J\u0015\u0006!A/[7f\u0015\tYE*\u0001\u0006fqR,gn]5p]NT!!\u0014(\u0002\u000b9dwnZ8\u000b\u0003=\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001*Y!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u0019\te.\u001f*fMB\u0011\u0011\fX\u0007\u00025*\u00111\fT\u0001\u0005G>\u0014X-\u0003\u0002^5\nyQ\t\u001f;f]NLwN\\(cU\u0016\u001cG/\u0001\u0004=S:LGO\u0010\u000b\u0002AB\u0011\u0011\rA\u0007\u0002\r\u0006AA-\u0019;f)f\u0004X-F\u0001e!\t)g-D\u0001I\u0013\t9\u0007J\u0001\u0005ECR,G+\u001f9f\u00031!\u0017\r^3UsB,w\fJ3r)\tQW\u000e\u0005\u0002TW&\u0011A\u000e\u0016\u0002\u0005+:LG\u000fC\u0004o\u0007\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\u0005eCR,G+\u001f9fA\u0005AA-\u0019;fi&lW-F\u0001s!\t\u0019x/D\u0001u\u0015\tIUOC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a$(!\u0004'pG\u0006dG)\u0019;f)&lW-\u0001\u0007eCR,G/[7f?\u0012*\u0017\u000f\u0006\u0002kw\"9aNBA\u0001\u0002\u0004\u0011\u0018!\u00033bi\u0016$\u0018.\\3!\u0003\u0011!\u0017\r^3\u0016\u0003}\u00042a]A\u0001\u0013\r\t\u0019\u0001\u001e\u0002\n\u0019>\u001c\u0017\r\u001c#bi\u0016\f\u0001\u0002Z1uK~#S-\u001d\u000b\u0004U\u0006%\u0001b\u00028\n\u0003\u0003\u0005\ra`\u0001\u0006I\u0006$X\rI\u0001\t[>tG\u000f\u001b#bsV\u0011\u0011\u0011\u0003\t\u0004g\u0006M\u0011bAA\u000bi\nAQj\u001c8uQ\u0012\u000b\u00170\u0001\u0007n_:$\b\u000eR1z?\u0012*\u0017\u000fF\u0002k\u00037A\u0001B\u001c\u0007\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\n[>tG\u000f\u001b#bs\u0002\n\u0011bY;ti>lg)\u001c;\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B/\u0001\u0004g_Jl\u0017\r^\u0005\u0005\u0003[\t9CA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\fQbY;ti>lg)\u001c;`I\u0015\fHc\u00016\u00024!AanDA\u0001\u0002\u0004\t\u0019#\u0001\u0006dkN$x.\u001c$ni\u0002\n!\u0002Z3gCVdGOR7u\u00039!WMZ1vYR4U\u000e^0%KF$2A[A\u001f\u0011!q'#!AA\u0002\u0005\r\u0012a\u00033fM\u0006,H\u000e\u001e$ni\u0002\n!\"[:B]\u000eDwN]3e+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY%^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\u0005%#a\u0002\"p_2,\u0017M\\\u0001\u000fSN\fen\u00195pe\u0016$w\fJ3r)\rQ\u0017Q\u000b\u0005\t]V\t\t\u00111\u0001\u0002F\u0005Y\u0011n]!oG\"|'/\u001a3!\u0003%!\u0018nY6WC2,X-\u0006\u0002\u0002^A!\u0011qIA0\u0013\u0011\t\t'!\u0013\u0003\r\u0011{WO\u00197f\u00035!\u0018nY6WC2,Xm\u0018\u0013fcR\u0019!.a\u001a\t\u00119D\u0012\u0011!a\u0001\u0003;\n!\u0002^5dWZ\u000bG.^3!\u0003!!\u0018nY6UsB,WCAA8!\r)\u0017\u0011O\u0005\u0004\u0003gB%A\u0003)fe&|G\rV=qK\u0006aA/[2l)f\u0004Xm\u0018\u0013fcR\u0019!.!\u001f\t\u00119\\\u0012\u0011!a\u0001\u0003_\n\u0011\u0002^5dWRK\b/\u001a\u0011\u0002\u001d\u0005t7\r[8s\t\u0006$X\r^5nK\u0006\u0011\u0012M\\2i_J$\u0015\r^3uS6,w\fJ3r)\rQ\u00171\u0011\u0005\b]z\t\t\u00111\u0001s\u0003=\tgn\u00195pe\u0012\u000bG/\u001a;j[\u0016\u0004\u0013AC1oG\"|'\u000fR1uK\u0006q\u0011M\\2i_J$\u0015\r^3`I\u0015\fHc\u00016\u0002\u000e\"9a.IA\u0001\u0002\u0004y\u0018aC1oG\"|'\u000fR1uK\u0002\na\"\u00198dQ>\u0014Xj\u001c8uQ\u0012\u000b\u00170\u0001\nb]\u000eDwN]'p]RDG)Y=`I\u0015\fHc\u00016\u0002\u0018\"Aa\u000eJA\u0001\u0002\u0004\t\t\"A\bb]\u000eDwN]'p]RDG)Y=!\u0003\u00159xN\u001d7e+\t\ty\n\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)\u000bT\u0001\u0006C\u001e,g\u000e^\u0005\u0005\u0003S\u000b\u0019KA\u0003X_JdG-A\u0005x_JdGm\u0018\u0013fcR\u0019!.a,\t\u00119<\u0013\u0011!a\u0001\u0003?\u000baa^8sY\u0012\u0004Cc\u00011\u00026\"1\u0011qW\u0015A\u0002I\f!\u0001\u001a;)\u000b%\nY,!4\u0011\u000bM\u000bi,!1\n\u0007\u0005}FK\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011q\u0019'\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002L\u0006\u0015'AE#yi\u0016t7/[8o\u000bb\u001cW\r\u001d;j_:\ftAHAh\u0003K\u00149\u0002\u0005\u0003\u0002R\u0006}g\u0002BAj\u00037\u00042!!6U\u001b\t\t9NC\u0002\u0002ZB\u000ba\u0001\u0010:p_Rt\u0014bAAo)\u00061\u0001K]3eK\u001aLA!!9\u0002d\n11\u000b\u001e:j]\u001eT1!!8Uc%\u0019\u0013q]Ax\u0005\u001b\t\t0\u0006\u0003\u0002j\u0006-XCAAh\t\u001d\ti\u000f\u0015b\u0001\u0003o\u0014\u0011\u0001V\u0005\u0005\u0003c\f\u00190A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003k$\u0016A\u0002;ie><8/\u0005\u0003\u0002z\u0006}\bcA*\u0002|&\u0019\u0011Q +\u0003\u000f9{G\u000f[5oOB!!\u0011\u0001B\u0004\u001d\r\u0019&1A\u0005\u0004\u0005\u000b!\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u0013\u0011YAA\u0005UQJ|w/\u00192mK*\u0019!Q\u0001+2\u0013\r\u0012yA!\u0005\u0003\u0014\u0005UhbA*\u0003\u0012%\u0019\u0011Q\u001f+2\u000b\t\u001aFK!\u0006\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\t\rF\u0003a\u00057\u0011y\u0002C\u0004\u0003\u001e)\u0002\r!a4\u0002\u001b\u0011\fG/Z*ue&tw-\u0011:h\u0011\u001d\u0011\tC\u000ba\u0001\u0005G\tAbY;ti>lgi\u001c:nCR\u0004Ra\u0015B\u0013\u0003\u001fL1Aa\nU\u0005\u0019y\u0005\u000f^5p]\"*!&a/\u0003,E:a$a4\u0003.\tM\u0012'C\u0012\u0002h\u0006=(qFAyc%\u0019#q\u0002B\t\u0005c\t)0M\u0003#'R\u0013)\"M\u0002'\u0003\u0003$2\u0001\u0019B\u001c\u0011\u001d\u0011Id\u000ba\u0001\u0003\u001f\f!\u0002Z1uKN#(/\u001b8h)\u001d\u0001'Q\bB \u0005\u0007BqA!\u000f-\u0001\u0004\ty\rC\u0004\u0003B1\u0002\r!a\t\u0002\u0015\u0011\fG/\u001a$pe6\fG\u000f\u0003\u0004\u0003F1\u0002\r\u0001Z\u0001\tI\u0006$X\r^=qKR\u0019\u0001M!\u0013\t\u000b%k\u0003\u0019\u00011\u0015\u0007\u0001\u0014i\u0005\u0003\u0004\u00028:\u0002\ra \u000b\u0004A\nE\u0003bBA\\_\u0001\u0007\u0011\u0011C\u0001\nG>l\u0007/\u0019:f)>$BAa\u0016\u0003^A\u00191K!\u0017\n\u0007\tmCKA\u0002J]RDaAa\u00181\u0001\u0004\u0001\u0017\u0001\u0002;iCR\f\u0001#[:DY>\u001cXM\u001d+p\u0003RC\u0017M\u001c\"\u0015\r\u0005\u0015#Q\rB5\u0011\u0019\u00119'\ra\u0001A\u0006)A/[7f\u0003\"1!1N\u0019A\u0002\u0001\fQ\u0001^5nK\n\u000bq\u0002]1sg\u0016$\u0015\r^3TiJLgn\u001a\u000b\u0005\u0003\u001f\u0014\t\bC\u0004\u0003tI\u0002\r!a4\u0002\u0017\u0011\fG/Z*ue&tw\r\u0016\u0015\u0006e\u0005m&qO\u0019\b=\u0005='\u0011\u0010B@c%\u0019\u0013q]Ax\u0005w\n\t0M\u0005$\u0005\u001f\u0011\tB! \u0002vF*!e\u0015+\u0003\u0016E\u001aa%!1\u0002\u001d\u0019|'/\\1u)>dUM\\4uQR1\u0011q\u001aBC\u0005\u000fCqA!\u000f4\u0001\u0004\ty\rC\u0004\u0003\nN\u0002\rAa\u0016\u0002\u001b\u0011,7/\u001b:fI2+gn\u001a;i\u0003%\u0001\u0018M]:f\t\u0006$X\r\u0006\u0003\u0002P\n=\u0005b\u0002BIi\u0001\u0007\u0011qZ\u0001\fI\u0006$X\rV5nKN#(\u000fK\u00035\u0003w\u0013)*M\u0004\u001f\u0003\u001f\u00149J!(2\u0013\r\n9/a<\u0003\u001a\u0006E\u0018'C\u0012\u0003\u0010\tE!1TA{c\u0015\u00113\u000b\u0016B\u000bc\r1\u0013\u0011Y\u0001\na\u0006\u00148/\u001a+j[\u0016$B!a4\u0003$\"9!\u0011S\u001bA\u0002\u0005=\u0007&B\u001b\u0002<\n\u001d\u0016g\u0002\u0010\u0002P\n%&qV\u0019\nG\u0005\u001d\u0018q\u001eBV\u0003c\f\u0014b\tB\b\u0005#\u0011i+!>2\u000b\t\u001aFK!\u00062\u0007\u0019\n\t-A\u0005tKR\fen\u00195peR9!N!.\u0003:\nm\u0006b\u0002B\\m\u0001\u0007\u0011QL\u0001\ni&\u001c7nQ8v]RDq!a\u001b7\u0001\u0004\ty\u0007C\u0004\u0002\u001cZ\u0002\r!a(\u0002\t\u0011,X\u000e\u001d\u000b\t\u0003\u001f\u0014\tM!3\u0003N\"9!1Y\u001cA\u0002\t\u0015\u0017\u0001B1sOF\u00022a\u0015Bd\u0013\r\ty\u0005\u0016\u0005\b\u0005\u0017<\u0004\u0019\u0001Bc\u0003\u0011\t'o\u001a\u001a\t\u000f\t=w\u00071\u0001\u0003F\u0006!\u0011M]44\u0003!!xn\u0015;sS:<GCAAh\u00039)\b\u000fZ1uK\u001a\u0013x.\u001c+jG.$\u0012A[\u0001\u0011O\u0016$X\t\u001f;f]NLwN\u001c(b[\u0016\fQbZ3u\u001d2#\u0016\u0010]3OC6,\u0017\u0001\u0005:fGV\u00148/\u001b<fYf,\u0015/^1m)\u0011\u0011)M!9\t\r\t\rH\b1\u0001S\u0003\u0011\t'o\u001a\u0019\u0002\tMDwn\u001e\u000b\u0005\u0003\u001f\u0014I\u000fC\u0004\u0003lv\u0002\r!a\t\u0002\u0007\u0019lG/A\u0002hKR$B!!\u0018\u0003r\"9!1\u001f A\u0002\u0005=\u0014A\u00039fe&|G\rV=qK\u0006!\u0001\u000f\\;t)\u0015\u0001'\u0011 B\u007f\u0011\u001d\u0011Yp\u0010a\u0001\u0003_\nQ\u0001\u001d+za\u0016DqAa@@\u0001\u0004\ti&\u0001\u0004ekJ4\u0016\r\u001c\u000b\bA\u000e\r1qAB\u0005\u0011\u0019\u0019)\u0001\u0011a\u0001%\u00069!/\u001a4US6,\u0007b\u0002B~\u0001\u0002\u0007\u0011q\u000e\u0005\b\u0007\u0017\u0001\u0005\u0019AA/\u0003%!WO\u001d,bY\u0006\u0013x-\u0001\u0005jg\n+gm\u001c:f)\u0011\u0011)m!\u0005\t\r\t-\u0014\t1\u0001a\u0003\u001dI7/R9vC2$BA!2\u0004\u0018!1!1\u000e\"A\u0002\u0001\f\u0011\"[:CKR<X-\u001a8\u0015\r\t\u00157QDB\u0011\u0011\u0019\u0019yb\u0011a\u0001A\u0006AA/[7f\u0003\u0006\u0013x\r\u0003\u0004\u0004$\r\u0003\r\u0001Y\u0001\ti&lWMQ!sO\u0006!r-\u001a;ES\u001a4WM]3oG\u0016\u0014U\r^<fK:$b!!\u0018\u0004*\r-\u0002b\u0002B~\t\u0002\u0007\u0011q\u000e\u0005\u0007\u0007[!\u0005\u0019\u00011\u0002\u000f\u0015tG\rV5nK\u0002")
public class LogoTime
implements ExtensionObject {
    private DateType dateType;
    private LocalDateTime datetime;
    private LocalDate date;
    private MonthDay monthDay;
    private DateTimeFormatter customFmt;
    private DateTimeFormatter defaultFmt;
    private Boolean isAnchored;
    private Double tickValue;
    private PeriodType tickType;
    private LocalDateTime anchorDatetime;
    private LocalDate anchorDate;
    private MonthDay anchorMonthDay;
    private World world;

    public DateType dateType() {
        return this.dateType;
    }

    public void dateType_$eq(DateType x$1) {
        this.dateType = x$1;
    }

    public LocalDateTime datetime() {
        return this.datetime;
    }

    public void datetime_$eq(LocalDateTime x$1) {
        this.datetime = x$1;
    }

    public LocalDate date() {
        return this.date;
    }

    public void date_$eq(LocalDate x$1) {
        this.date = x$1;
    }

    public MonthDay monthDay() {
        return this.monthDay;
    }

    public void monthDay_$eq(MonthDay x$1) {
        this.monthDay = x$1;
    }

    private DateTimeFormatter customFmt() {
        return this.customFmt;
    }

    private void customFmt_$eq(DateTimeFormatter x$1) {
        this.customFmt = x$1;
    }

    private DateTimeFormatter defaultFmt() {
        return this.defaultFmt;
    }

    private void defaultFmt_$eq(DateTimeFormatter x$1) {
        this.defaultFmt = x$1;
    }

    private Boolean isAnchored() {
        return this.isAnchored;
    }

    private void isAnchored_$eq(Boolean x$1) {
        this.isAnchored = x$1;
    }

    private Double tickValue() {
        return this.tickValue;
    }

    private void tickValue_$eq(Double x$1) {
        this.tickValue = x$1;
    }

    private PeriodType tickType() {
        return this.tickType;
    }

    private void tickType_$eq(PeriodType x$1) {
        this.tickType = x$1;
    }

    private LocalDateTime anchorDatetime() {
        return this.anchorDatetime;
    }

    private void anchorDatetime_$eq(LocalDateTime x$1) {
        this.anchorDatetime = x$1;
    }

    private LocalDate anchorDate() {
        return this.anchorDate;
    }

    private void anchorDate_$eq(LocalDate x$1) {
        this.anchorDate = x$1;
    }

    private MonthDay anchorMonthDay() {
        return this.anchorMonthDay;
    }

    private void anchorMonthDay_$eq(MonthDay x$1) {
        this.anchorMonthDay = x$1;
    }

    private World world() {
        return this.world;
    }

    private void world_$eq(World x$1) {
        this.world = x$1;
    }

    public int compareTo(LogoTime that) {
        DateType dateType = this.dateType();
        int n = DateTime$.MODULE$.equals(dateType) ? this.datetime().compareTo(that.datetime()) : (Date$.MODULE$.equals(dateType) ? this.date().compareTo(that.date()) : (DayDate$.MODULE$.equals(dateType) ? this.monthDay().compareTo(that.monthDay()) : -999));
        return n;
    }

    public Boolean isCloserToAThanB(LogoTime timeA, LogoTime timeB) {
        LocalDateTime refDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Long millisToA = null;
        Long millisToB = null;
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.datetime().with(refDateTime), this.datetime().with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.datetime().with(refDateTime), this.datetime().with(refDateTime)).toMillis()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Date$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.date().with(refDateTime), this.date().with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.date().with(refDateTime), this.date().with(refDateTime)).toMillis()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DayDate$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.monthDay().atYear(2000).with(refDateTime), this.monthDay().atYear(2000).with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.monthDay().atYear(2000).with(refDateTime), this.monthDay().atYear(2000).with(refDateTime)).toMillis()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dateType);
        }
        return Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Long2long(millisToA) < Predef$.MODULE$.Long2long(millisToB));
    }

    public String parseDateString(String dateStringT) throws ExtensionException {
        String string;
        char delimiter = new StringOps(Predef$.MODULE$.augmentString(dateStringT)).contains((Object)BoxesRunTime.boxToCharacter((char)'-')) ? (char)'-' : '/';
        String dateString = dateStringT.replace('/', '-').replace(' ', 'T');
        String[] timefragments = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dateString.split("T"))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String string2 = dateString;
        if ("".equals(string2)) {
            string = "";
        } else if ("now".equals(string2)) {
            string = "now";
        } else if (timefragments.length == 2 && new StringOps(Predef$.MODULE$.augmentString(dateString)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) {
            this.dateType_$eq(DateTime$.MODULE$);
            string = new StringBuilder(1).append(this.parseDate(timefragments[0])).append("T").append(this.parseTime(timefragments[1])).toString();
        } else if (timefragments.length == 1 && !new StringOps(Predef$.MODULE$.augmentString(string2)).contains((Object)BoxesRunTime.boxToCharacter((char)':')) && new StringOps(Predef$.MODULE$.augmentString(string2)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) {
            if (string2.length() < 6) {
                this.dateType_$eq(DayDate$.MODULE$);
            } else {
                this.dateType_$eq(Date$.MODULE$);
            }
            string = this.parseDate(timefragments[0]);
        } else {
            throw new ExtensionException(new StringBuilder(25).append("Invalid string fragment: ").append(string2).toString());
        }
        return string.replace('-', delimiter);
    }

    public String formatToLength(String dateString, int desiredLength) {
        return dateString.length() >= desiredLength ? dateString : new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(desiredLength - dateString.length())).append(dateString).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseDate(String dateTimeStr) throws ExtensionException {
        Option option;
        String string;
        String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(dateTimeStr)).split('-');
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && "".equals(string = (String)((SeqLike)option2.get()).apply(0))) {
            return "";
        }
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(3) == 0) {
            String date1 = (String)((SeqLike)option3.get()).apply(0);
            String date2 = (String)((SeqLike)option3.get()).apply(1);
            String date3 = (String)((SeqLike)option3.get()).apply(2);
            if (dateTimeStr.length() < 11) return new StringBuilder(2).append(this.formatToLength(date1, 2)).append("-").append(this.formatToLength(date2, 2)).append("-").append(this.formatToLength(date3, 2)).toString();
            if (date1.length() != 3) return new StringBuilder(2).append(this.formatToLength(date1, 2)).append("-").append(this.formatToLength(date2, 2)).append("-").append(this.formatToLength(date3, 2)).toString();
            if (date2.length() != 3) return new StringBuilder(2).append(this.formatToLength(date1, 2)).append("-").append(this.formatToLength(date2, 2)).append("-").append(this.formatToLength(date3, 2)).toString();
            if (date1.length() != 3) {
                return new StringBuilder(2).append(this.formatToLength(date1, 2)).append("-").append(this.formatToLength(date2, 2)).append("-").append(this.formatToLength(date3, 2)).toString();
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw new ExtensionException("Illegal Date String(DateTime Error)");
        if (option.get() == null) throw new ExtensionException("Illegal Date String(DateTime Error)");
        if (((SeqLike)option.get()).lengthCompare(2) != 0) throw new ExtensionException("Illegal Date String(DateTime Error)");
        String date1 = (String)((SeqLike)option.get()).apply(0);
        String date2 = (String)((SeqLike)option.get()).apply(1);
        if (dateTimeStr.length() >= 6) throw new ExtensionException("Illegal Date String(DateTime Error)");
        return new StringBuilder(1).append(this.formatToLength(date1, 2)).append("-").append(this.formatToLength(date2, 2)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseTime(String dateTimeStr) throws ExtensionException {
        Option option;
        Option option2;
        String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(dateTimeStr)).split(':');
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(3) == 0) {
            String hour = (String)((SeqLike)option3.get()).apply(0);
            String minute = (String)((SeqLike)option3.get()).apply(1);
            String second = (String)((SeqLike)option3.get()).apply(2);
            if (new StringBuilder(2).append(hour).append(":").append(minute).append(":").toString().length() < 7) {
                return new StringBuilder(2).append(this.formatToLength(hour, 2)).append(":").append(this.formatToLength(minute, 2)).append(":").append(this.formatSeconds$1().apply((Object)second)).toString();
            }
        }
        if (!(option2 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
            String hour = (String)((SeqLike)option2.get()).apply(0);
            String minute = (String)((SeqLike)option2.get()).apply(1);
            if (dateTimeStr.length() < 6) {
                return new StringBuilder(8).append(this.formatToLength(hour, 2)).append(":").append(this.formatToLength(minute, 2)).append(":00.000").toString();
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw new ExtensionException(new StringBuilder(21).append("Invalid Time String: ").append(stringArray).toString());
        if (option.get() == null) throw new ExtensionException(new StringBuilder(21).append("Invalid Time String: ").append(stringArray).toString());
        if (((SeqLike)option.get()).lengthCompare(1) != 0) throw new ExtensionException(new StringBuilder(21).append("Invalid Time String: ").append(stringArray).toString());
        String hour = (String)((SeqLike)option.get()).apply(0);
        if (dateTimeStr.length() >= 3) throw new ExtensionException(new StringBuilder(21).append("Invalid Time String: ").append(stringArray).toString());
        return new StringBuilder(10).append(this.formatToLength(hour, 2)).append(":00").append(":00.000").toString();
    }

    public void setAnchor(Double tickCount, PeriodType tickType, World world) {
        PeriodType periodType = tickType;
        DayOfWeek$ dayOfWeek$ = DayOfWeek$.MODULE$;
        if (!(periodType != null ? !periodType.equals(dayOfWeek$) : dayOfWeek$ != null)) {
            throw new ExtensionException(new StringBuilder(34).append(tickType.toString()).append(" type is not a supported tick type").toString());
        }
        this.isAnchored_$eq(Predef$.MODULE$.boolean2Boolean(true));
        this.tickValue_$eq(tickCount);
        this.tickType_$eq(tickType);
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.anchorDatetime_$eq(LocalDateTime.from(this.datetime()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Date$.MODULE$.equals(dateType)) {
            this.anchorDate_$eq(LocalDate.from(this.date()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DayDate$.MODULE$.equals(dateType)) {
            this.anchorMonthDay_$eq(MonthDay.from(this.monthDay()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dateType);
        }
        this.world_$eq(world);
    }

    public String dump(boolean arg1, boolean arg2, boolean arg3) {
        return this.toString();
    }

    public String toString() {
        String string;
        try {
            this.updateFromTick();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            string = this.datetime().format(fmt);
        } else if (Date$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            string = this.date().format(fmt);
        } else if (DayDate$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            string = this.monthDay().format(fmt);
        } else {
            string = "";
        }
        return string;
    }

    public void updateFromTick() {
        if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored())) {
            return;
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.datetime_$eq(this.plus(this.anchorDatetime(), this.tickType(), Predef$.MODULE$.double2Double(this.world().ticks() * Predef$.MODULE$.Double2double(this.tickValue()))).datetime());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Date$.MODULE$.equals(dateType)) {
            this.date_$eq(this.plus(this.anchorDate(), this.tickType(), Predef$.MODULE$.double2Double(this.world().ticks() * Predef$.MODULE$.Double2double(this.tickValue()))).date());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DayDate$.MODULE$.equals(dateType)) {
            this.monthDay_$eq(this.plus(this.anchorMonthDay(), this.tickType(), Predef$.MODULE$.double2Double(this.world().ticks() * Predef$.MODULE$.Double2double(this.tickValue()))).monthDay());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dateType);
        }
    }

    public String getExtensionName() {
        return "time";
    }

    public String getNLTypeName() {
        return "logotime";
    }

    public boolean recursivelyEqual(Object arg0) {
        return this.equals(arg0);
    }

    public String show(DateTimeFormatter fmt) {
        String string;
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            string = this.datetime().format(fmt);
        } else if (Date$.MODULE$.equals(dateType)) {
            string = this.date().atStartOfDay().format(fmt);
        } else if (DayDate$.MODULE$.equals(dateType)) {
            string = this.monthDay().atYear(2000).atStartOfDay().format(fmt);
        } else {
            throw new MatchError((Object)dateType);
        }
        return string;
    }

    public Double get(PeriodType periodType) {
        Double d;
        PeriodType periodType2 = periodType;
        if (Milli$.MODULE$.equals(periodType2)) {
            Double d2;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d2 = Predef$.MODULE$.double2Double((double)(this.datetime().getNano() / 1000000));
            } else if (Date$.MODULE$.equals(dateType)) {
                d2 = Predef$.MODULE$.double2Double((double)(this.date().atStartOfDay().getNano() / 1000000));
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d2 = Predef$.MODULE$.double2Double((double)(this.monthDay().atYear(2000).atStartOfDay().getNano() / 1000000));
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d2;
        } else if (Second$.MODULE$.equals(periodType2)) {
            Double d3;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d3 = Predef$.MODULE$.double2Double((double)this.datetime().getSecond());
            } else if (Date$.MODULE$.equals(dateType)) {
                d3 = Predef$.MODULE$.double2Double((double)this.date().atStartOfDay().getSecond());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d3 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).atStartOfDay().getSecond());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d3;
        } else if (Minute$.MODULE$.equals(periodType2)) {
            Double d4;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d4 = Predef$.MODULE$.double2Double((double)this.datetime().getMinute());
            } else if (Date$.MODULE$.equals(dateType)) {
                d4 = Predef$.MODULE$.double2Double((double)this.date().atStartOfDay().getMinute());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d4 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).atStartOfDay().getMinute());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d4;
        } else if (Hour$.MODULE$.equals(periodType2)) {
            Double d5;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d5 = Predef$.MODULE$.double2Double((double)this.datetime().getHour());
            } else if (Date$.MODULE$.equals(dateType)) {
                d5 = Predef$.MODULE$.double2Double((double)this.date().atStartOfDay().getHour());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d5 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).atStartOfDay().getHour());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d5;
        } else if (Day$.MODULE$.equals(periodType2)) {
            Double d6;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d6 = Predef$.MODULE$.double2Double((double)this.datetime().getDayOfMonth());
            } else if (Date$.MODULE$.equals(dateType)) {
                d6 = Predef$.MODULE$.double2Double((double)this.date().getDayOfMonth());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d6 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).getDayOfMonth());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d6;
        } else if (DayOfYear$.MODULE$.equals(periodType2)) {
            Double d7;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d7 = Predef$.MODULE$.double2Double((double)this.datetime().getDayOfYear());
            } else if (Date$.MODULE$.equals(dateType)) {
                d7 = Predef$.MODULE$.double2Double((double)this.date().getDayOfYear());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d7 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).getDayOfYear());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d7;
        } else if (DayOfWeek$.MODULE$.equals(periodType2)) {
            Double d8;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d8 = Predef$.MODULE$.double2Double((double)this.datetime().getDayOfWeek().getValue());
            } else if (Date$.MODULE$.equals(dateType)) {
                d8 = Predef$.MODULE$.double2Double((double)this.date().getDayOfWeek().getValue());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d8 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).getDayOfWeek().getValue());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d8;
        } else if (Week$.MODULE$.equals(periodType2)) {
            Double d9;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d9 = Predef$.MODULE$.double2Double((double)this.datetime().get(WeekFields.SUNDAY_START.weekOfYear()));
            } else if (Date$.MODULE$.equals(dateType)) {
                d9 = Predef$.MODULE$.double2Double((double)this.date().get(WeekFields.SUNDAY_START.weekOfYear()));
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d9 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).get(WeekFields.SUNDAY_START.weekOfYear()));
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d9;
        } else if (Month$.MODULE$.equals(periodType2)) {
            Double d10;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d10 = Predef$.MODULE$.double2Double((double)this.datetime().getMonthValue());
            } else if (Date$.MODULE$.equals(dateType)) {
                d10 = Predef$.MODULE$.double2Double((double)this.date().getMonthValue());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d10 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).getMonthValue());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d10;
        } else if (Year$.MODULE$.equals(periodType2)) {
            Double d11;
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                d11 = Predef$.MODULE$.double2Double((double)this.datetime().getYear());
            } else if (Date$.MODULE$.equals(dateType)) {
                d11 = Predef$.MODULE$.double2Double((double)this.date().atStartOfDay().getYear());
            } else if (DayDate$.MODULE$.equals(dateType)) {
                d11 = Predef$.MODULE$.double2Double((double)this.monthDay().atYear(2000).getYear());
            } else {
                throw new MatchError((Object)dateType);
            }
            d = d11;
        } else {
            throw new ExtensionException("Incorrect Time Unit");
        }
        return d;
    }

    public LogoTime plus(PeriodType pType, Double durVal) {
        DateType dateType = this.dateType();
        LogoTime logoTime = DateTime$.MODULE$.equals(dateType) ? this.plus(this.datetime(), pType, durVal) : (Date$.MODULE$.equals(dateType) ? this.plus(this.date(), pType, durVal) : (DayDate$.MODULE$.equals(dateType) ? this.plus(this.monthDay(), pType, durVal) : this));
        return logoTime;
    }

    public LogoTime plus(Object refTime, PeriodType pType, Double durValArg) {
        LogoTime logoTime;
        None$ per = None$.MODULE$;
        Double durVal = durValArg;
        PeriodType periodType = pType;
        if (Week$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)604800000);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Day$.MODULE$.equals(periodType) ? true : DayOfYear$.MODULE$.equals(periodType);
            if (bl) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)86400000);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Hour$.MODULE$.equals(periodType)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)3600000);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Minute$.MODULE$.equals(periodType)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)60000);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Second$.MODULE$.equals(periodType)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)1000);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Milli$.MODULE$.equals(periodType)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Month$.MODULE$.equals(periodType)) {
                per = new Some((Object)Period.of(0, Predef$.MODULE$.Integer2int(TimeUtils$.MODULE$.roundDouble(durVal)), 0));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Year$.MODULE$.equals(periodType)) {
                per = new Some((Object)Period.of(Predef$.MODULE$.Integer2int(TimeUtils$.MODULE$.roundDouble(durVal)), 0, 0));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new ExtensionException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)pType), " type is not supported by the time:plus primitive"));
            }
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            LogoTime logoTime2;
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                logoTime2 = new LogoTime(((LocalDateTime)refTime).plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS)));
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Period period = (Period)some.value();
                logoTime2 = new LogoTime(((LocalDateTime)refTime).plus(period));
            } else {
                throw new MatchError((Object)none$);
            }
            logoTime = logoTime2;
        } else if (Date$.MODULE$.equals(dateType)) {
            LogoTime logoTime3;
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                LocalDate logotime = ((LocalDate)refTime).atStartOfDay().plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS)).toLocalDate();
                logoTime3 = new LogoTime(logotime);
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Period period = (Period)some.value();
                logoTime3 = new LogoTime(((LocalDate)refTime).plus(period));
            } else {
                throw new MatchError((Object)none$);
            }
            logoTime = logoTime3;
        } else if (DayDate$.MODULE$.equals(dateType)) {
            LogoTime logoTime4;
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                logoTime4 = new LogoTime(MonthDay.from(((MonthDay)refTime).atYear(2000).atStartOfDay().plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS))));
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Period period = (Period)some.value();
                logoTime4 = new LogoTime(MonthDay.from(((MonthDay)refTime).atYear(2000).atStartOfDay().plus(period)));
            } else {
                throw new MatchError((Object)none$);
            }
            logoTime = logoTime4;
        } else {
            throw new ExtensionException(new StringBuilder(30).append(dateType).append(" type does not match datatypes").toString());
        }
        return logoTime;
    }

    public boolean isBefore(LogoTime timeB) {
        DateType dateType = this.dateType();
        DateType dateType2 = timeB.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException(new StringBuilder(96).append("time comparisons only work if the LogoTime's are the same variety, but you called with a ").append(this.dateType().toString()).append(" and a ").append(timeB.dateType().toString()).toString());
        }
        DateType dateType3 = this.dateType();
        boolean bl = DateTime$.MODULE$.equals(dateType3) ? this.datetime().isBefore(timeB.datetime()) : (Date$.MODULE$.equals(dateType3) ? this.date().isBefore(timeB.date()) : (DayDate$.MODULE$.equals(dateType3) ? this.monthDay().isBefore(timeB.monthDay()) : true));
        return bl;
    }

    public boolean isEqual(LogoTime timeB) {
        DateType dateType = this.dateType();
        DateType dateType2 = timeB.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException(new StringBuilder(96).append("time comparisons only work if the LogoTime's are the same variety, but you called with a ").append(this.dateType().toString()).append(" and a ").append(timeB.dateType().toString()).toString());
        }
        DateType dateType3 = this.dateType();
        boolean bl = DateTime$.MODULE$.equals(dateType3) ? this.datetime().isEqual(timeB.datetime()) : (Date$.MODULE$.equals(dateType3) ? this.date().isEqual(timeB.date()) : (DayDate$.MODULE$.equals(dateType3) ? this.monthDay().equals(timeB.monthDay()) : true));
        return bl;
    }

    public boolean isBetween(LogoTime timeAArg, LogoTime timeBArg) {
        LogoTime timeB;
        LogoTime timeA;
        block5: {
            block4: {
                timeA = timeAArg;
                timeB = timeBArg;
                if (!timeA.isBefore(timeB)) {
                    LogoTime tempA = timeA;
                    timeA = timeB;
                    timeB = tempA;
                }
                DateType dateType = this.dateType();
                DateType dateType2 = timeA.dateType();
                if (dateType != null ? !dateType.equals(dateType2) : dateType2 != null) break block4;
                DateType dateType3 = this.dateType();
                DateType dateType4 = timeB.dateType();
                if (!(dateType3 == null ? dateType4 != null : !dateType3.equals(dateType4))) break block5;
            }
            throw new ExtensionException(new StringBuilder(101).append("time comparisons only work if the LogoTime's are the same variety, but you called with a ").append(this.dateType().toString()).append(", a ").append(timeA.dateType().toString()).append(", and a ").append(timeB.dateType().toString()).toString());
        }
        DateType dateType = this.dateType();
        boolean bl = DateTime$.MODULE$.equals(dateType) ? this.datetime().isAfter(timeA.datetime()) && this.datetime().isBefore(timeB.datetime()) || this.datetime().isEqual(timeA.datetime()) || this.datetime().isEqual(timeB.datetime()) : (Date$.MODULE$.equals(dateType) ? this.date().isAfter(timeA.date()) && this.date().isBefore(timeB.date()) || this.date().isEqual(timeA.date()) || this.date().isEqual(timeB.date()) : (DayDate$.MODULE$.equals(dateType) ? (timeA.monthDay().equals(timeAArg.monthDay()) ? this.monthDay().isAfter(timeA.monthDay()) && this.monthDay().isBefore(timeB.monthDay()) || this.monthDay().equals(timeA.monthDay()) || this.monthDay().equals(timeB.monthDay()) : this.monthDay().isBefore(timeBArg.monthDay()) || this.monthDay().equals(timeA.monthDay()) || this.monthDay().equals(timeB.monthDay())) : true));
        return bl;
    }

    public Double getDifferenceBetween(PeriodType pType, LogoTime endTime) {
        Double d;
        DateType dateType = this.dateType();
        DateType dateType2 = endTime.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException(new StringBuilder(95).append("time comparisons only work if the LogoTimes are the same variety, but you called with a ").append(this.dateType().toString()).append(" and a ").append(endTime.dateType().toString()).toString());
        }
        Double durVal = Predef$.MODULE$.double2Double(1.0);
        PeriodType periodType = pType;
        if (Year$.MODULE$.equals(periodType)) {
            Double d2;
            DateType dateType3 = this.dateType();
            if (DateTime$.MODULE$.equals(dateType3)) {
                d2 = TimeUtils$.MODULE$.intToDouble(Period.between(this.datetime().toLocalDate(), endTime.datetime().toLocalDate()).getYears());
            } else if (Date$.MODULE$.equals(dateType3)) {
                d2 = TimeUtils$.MODULE$.intToDouble(Period.between(this.date(), endTime.date()).getYears());
            } else {
                if (DayDate$.MODULE$.equals(dateType3)) {
                    throw new ExtensionException(new StringBuilder(90).append(pType).append(" type is not supported by the time:difference-between primitive with LogoTimes of type DAY").toString());
                }
                throw new MatchError((Object)dateType3);
            }
            d = d2;
        } else if (Month$.MODULE$.equals(periodType)) {
            Double d3;
            DateType dateType4 = this.dateType();
            if (DateTime$.MODULE$.equals(dateType4)) {
                d3 = TimeUtils$.MODULE$.intToDouble(Period.between(this.datetime().toLocalDate(), endTime.datetime().toLocalDate()).getMonths());
            } else if (Date$.MODULE$.equals(dateType4)) {
                d3 = TimeUtils$.MODULE$.intToDouble(Period.between(this.date(), endTime.date()).getMonths());
            } else if (DayDate$.MODULE$.equals(dateType4)) {
                d3 = TimeUtils$.MODULE$.intToDouble(Period.between(this.monthDay().atYear(2000), endTime.monthDay().atYear(2000)).getMonths());
            } else {
                throw new MatchError((Object)dateType4);
            }
            d = d3;
        } else {
            boolean bl = Week$.MODULE$.equals(periodType) ? true : (Day$.MODULE$.equals(periodType) ? true : (DayOfYear$.MODULE$.equals(periodType) ? true : (Hour$.MODULE$.equals(periodType) ? true : (Minute$.MODULE$.equals(periodType) ? true : (Second$.MODULE$.equals(periodType) ? true : Milli$.MODULE$.equals(periodType))))));
            if (bl) {
                Double d4;
                PeriodType periodType2 = pType;
                if (Week$.MODULE$.equals(periodType2)) {
                    durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 6.048E8);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl2 = Day$.MODULE$.equals(periodType2) ? true : DayOfYear$.MODULE$.equals(periodType2);
                    if (bl2) {
                        durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 8.64E7);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (Hour$.MODULE$.equals(periodType2)) {
                        durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 3600000.0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (Minute$.MODULE$.equals(periodType2)) {
                        durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 60000.0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (Second$.MODULE$.equals(periodType2)) {
                        durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)1000);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (Milli$.MODULE$.equals(periodType2)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new ExtensionException(new StringBuilder(71).append(pType).append(" testing type is not supported by the time:difference-between primitive").toString());
                    }
                }
                DateType dateType5 = this.dateType();
                if (DateTime$.MODULE$.equals(dateType5)) {
                    d4 = Predef$.MODULE$.double2Double((double)Duration.between(this.datetime(), endTime.datetime()).toMillis() / Predef$.MODULE$.Double2double(durVal));
                } else if (Date$.MODULE$.equals(dateType5)) {
                    d4 = Predef$.MODULE$.double2Double((double)Duration.between(this.date().atStartOfDay(), endTime.date().atStartOfDay()).toMillis() / Predef$.MODULE$.Double2double(durVal));
                } else if (DayDate$.MODULE$.equals(dateType5)) {
                    d4 = Predef$.MODULE$.double2Double((double)Duration.between(this.monthDay().atYear(2000).atStartOfDay(), endTime.monthDay().atYear(2000).atStartOfDay()).toMillis() / Predef$.MODULE$.Double2double(durVal));
                } else {
                    throw new ExtensionException(new StringBuilder(64).append(pType).append(" ptype is not supported by the time:difference-between primitive").toString());
                }
                d = d4;
            } else {
                throw new ExtensionException(new StringBuilder(70).append(pType).append(" coding type is not supported by the time:difference-between primitive").toString());
            }
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(char x$1) {
        return x$1 == 'S';
    }

    public static final /* synthetic */ boolean $anonfun$new$2(char x$2) {
        return x$2 == 'S';
    }

    private final Function1 formatSeconds$1() {
        return (Function1 & Serializable & scala.Serializable)secondAndMillis -> {
            Option option;
            Option option2;
            String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(secondAndMillis)).split('.');
            Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
                String sec = (String)((SeqLike)option3.get()).apply(0);
                String milli = (String)((SeqLike)option3.get()).apply(1);
                if (sec.length() <= 2 && milli.length() <= 3) {
                    return new StringBuilder(1).append(this.formatToLength(sec, 2)).append(".").append(milli).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(3 - milli.length())).toString();
                }
            }
            if (!(option2 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                String sec = (String)((SeqLike)option2.get()).apply(0);
                String milli = (String)((SeqLike)option2.get()).apply(1);
                if (sec.length() <= 2 && milli.length() > 3) {
                    return new StringBuilder(1).append(this.formatToLength(sec, 2)).append(".").append(new StringOps(Predef$.MODULE$.augmentString(milli)).take(3)).toString();
                }
            }
            if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw new ExtensionException("Illegal Second String");
            if (option.get() == null) throw new ExtensionException("Illegal Second String");
            if (((SeqLike)option.get()).lengthCompare(1) != 0) throw new ExtensionException("Illegal Second String");
            String sec = (String)((SeqLike)option.get()).apply(0);
            if (sec.length() > 2) throw new ExtensionException("Illegal Second String");
            return new StringBuilder(4).append(this.formatToLength(sec, 2)).append(".000").toString();
        };
    }

    public LogoTime() {
        this.dateType = DateTime$.MODULE$;
        this.datetime = null;
        this.date = null;
        this.monthDay = null;
        this.customFmt = null;
        this.defaultFmt = new DateTimeFormatterBuilder().parseStrict().appendPattern("uuuu-MM-dd HH:mm:ss.").parseLenient().appendPattern("SSS").toFormatter();
        this.isAnchored = Predef$.MODULE$.boolean2Boolean(false);
    }

    public LogoTime(LocalDateTime dt) throws ExtensionException {
        this();
        this.datetime_$eq(dt);
    }

    /*
     * Unable to fully structure code
     */
    public LogoTime(String dateStringArg, Option<String> customFormat) throws ExtensionException {
        block25: {
            this();
            dateString = dateStringArg.replace('T', ' ').replace('Y', 'y');
            var9_4 = customFormat;
            if (None$.MODULE$.equals(var9_4)) {
                dateString = this.parseDateString(dateString).replace('T', ' ');
                var7_5 = BoxedUnit.UNIT;
            } else if (var9_4 instanceof Some) {
                var10_7 = (Some)var9_4;
                customForm = (String)var10_7.value();
                this.dateType_$eq(customForm.indexOf(72) >= 0 || customForm.indexOf(104) >= 0 || customForm.indexOf(83) >= 0 || customForm.indexOf(115) >= 0 || customForm.indexOf(75) >= 0 || customForm.indexOf(107) >= 0 || customForm.indexOf(109) >= 0 ? DateTime$.MODULE$ : (customForm.indexOf(89) >= 0 || customForm.indexOf(121) >= 0 ? Date$.MODULE$ : DayDate$.MODULE$));
                var7_6 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var9_4);
            }
            var12_9 = this.dateType();
            if (DateTime$.MODULE$.equals(var12_9)) {
                var6_10 = new DateTimeFormatterBuilder().parseStrict().appendPattern("uuuu-MM-dd HH:mm:ss.").parseLenient().appendPattern("SSS").toFormatter().withResolverStyle(ResolverStyle.STRICT);
            } else if (Date$.MODULE$.equals(var12_9)) {
                var6_10 = DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT);
            } else if (DayDate$.MODULE$.equals(var12_9)) {
                var6_10 = DateTimeFormatter.ofPattern("MM-dd").withResolverStyle(ResolverStyle.STRICT);
            } else {
                throw new MatchError((Object)var12_9);
            }
            this.defaultFmt_$eq(var6_10);
            try {
                block26: {
                    block28: {
                        block27: {
                            var13_11 = customFormat;
                            if (!None$.MODULE$.equals(var13_11)) break block26;
                            dateString = dateString.replace(' ', 'T').replace('/', '-');
                            var14_12 = this.dateType();
                            if (!DateTime$.MODULE$.equals(var14_12)) break block27;
                            if (dateString.length() == 0) ** GOTO lbl-1000
                            v0 = dateString;
                            var15_13 = "now";
                            if (!(v0 != null ? v0.equals(var15_13) == false : var15_13 != null)) lbl-1000:
                            // 2 sources

                            {
                                v1 = LocalDateTime.now();
                            } else {
                                v1 = LocalDateTime.parse(dateString);
                            }
                            this.datetime_$eq(v1);
                            var5_14 = BoxedUnit.UNIT;
                            break block28;
                        }
                        if (Date$.MODULE$.equals(var14_12)) {
                            this.date_$eq(LocalDate.parse(dateString));
                            var5_15 = BoxedUnit.UNIT;
                        } else if (DayDate$.MODULE$.equals(var14_12)) {
                            this.monthDay_$eq(MonthDay.parse(dateString, this.defaultFmt()));
                            var5_16 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)var14_12);
                        }
                    }
                    var3_17 = BoxedUnit.UNIT;
                    break block25;
                }
                if (var13_11 instanceof Some) {
                    var16_19 = (Some)var13_11;
                    customForm = (String)var16_19.value();
                    this.customFmt_$eq(customForm.endsWith("S") != false && new StringOps(Predef$.MODULE$.augmentString(customForm)).count((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$new$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)()) < 4 ? new DateTimeFormatterBuilder().parseStrict().appendPattern(((String)new StringOps(Predef$.MODULE$.augmentString(customForm)).filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$new$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)())).replace('Y', 'y').replace('y', 'u')).parseStrict().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, false).toFormatter().withResolverStyle(ResolverStyle.STRICT) : new DateTimeFormatterBuilder().parseStrict().appendPattern(customForm.replace('Y', 'y').replace('y', 'u')).toFormatter().withResolverStyle(ResolverStyle.STRICT));
                    var18_21 = this.dateType();
                    if (DateTime$.MODULE$.equals(var18_21)) {
                        this.datetime_$eq(LocalDateTime.parse(dateString, this.customFmt()));
                        var4_22 = BoxedUnit.UNIT;
                    } else if (Date$.MODULE$.equals(var18_21)) {
                        this.date_$eq(LocalDate.parse(dateString, this.customFmt()));
                        var4_23 = BoxedUnit.UNIT;
                    } else if (DayDate$.MODULE$.equals(var18_21)) {
                        this.monthDay_$eq(MonthDay.parse(dateString, this.customFmt()));
                        var4_24 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var18_21);
                    }
                    var3_18 = BoxedUnit.UNIT;
                    break block25;
                }
                throw new MatchError(var13_11);
            }
            catch (DateTimeParseException e) {
                throw new ExtensionException(new StringBuilder(38).append("Extension could not parse input: ").append(dateString).append(" and ").append(customFormat).toString());
            }
        }
    }

    public LogoTime(String dateString) {
        this(dateString, (Option<String>)None$.MODULE$);
    }

    public LogoTime(String dateString, DateTimeFormatter dateFormat, DateType datetype) {
        this();
        this.dateType_$eq(datetype);
        this.customFmt_$eq(dateFormat);
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.datetime_$eq(LocalDateTime.parse(dateString, dateFormat));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Date$.MODULE$.equals(dateType)) {
            this.date_$eq(LocalDate.parse(dateString, dateFormat));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DayDate$.MODULE$.equals(dateType)) {
            this.monthDay_$eq(MonthDay.parse(dateString, dateFormat));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dateType);
        }
    }

    public LogoTime(LogoTime time) {
        this(time.show(time.customFmt() == null ? time.defaultFmt() : time.customFmt()), time.customFmt() == null ? time.defaultFmt() : time.customFmt(), time.dateType());
    }

    public LogoTime(LocalDate dt) {
        this();
        this.date_$eq(dt);
        this.defaultFmt_$eq(DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT));
        this.dateType_$eq(Date$.MODULE$);
    }

    public LogoTime(MonthDay dt) {
        this();
        this.monthDay_$eq(dt);
        this.defaultFmt_$eq(DateTimeFormatter.ofPattern("MM-dd").withResolverStyle(ResolverStyle.STRICT));
        this.dateType_$eq(DayDate$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$new$1$adapted(Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)LogoTime.$anonfun$new$1(BoxesRunTime.unboxToChar((Object)x$1)));
    }

    public static final /* synthetic */ Object $anonfun$new$2$adapted(Object x$2) {
        return BoxesRunTime.boxToBoolean((boolean)LogoTime.$anonfun$new$2(BoxesRunTime.unboxToChar((Object)x$2)));
    }
}

