/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.TapeTimecode;
import org.jcodec.containers.mkv.MKVParser;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.boxes.EbmlBase;
import org.jcodec.containers.mkv.boxes.EbmlBin;
import org.jcodec.containers.mkv.boxes.EbmlFloat;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.boxes.EbmlUint;
import org.jcodec.containers.mkv.boxes.MkvBlock;

public final class MKVDemuxer {
    private VideoTrack vTrack = null;
    private List<DemuxerTrack> aTracks = new ArrayList<DemuxerTrack>();
    private List<EbmlMaster> t;
    private SeekableByteChannel channel;
    long timescale = 1L;
    int pictureWidth;
    int pictureHeight;
    private static final TapeTimecode ZERO_TAPE_TIMECODE = new TapeTimecode(0, 0, 0, 0, false);

    public MKVDemuxer(List<EbmlMaster> t, SeekableByteChannel fileChannelWrapper) {
        this.t = t;
        this.channel = fileChannelWrapper;
        this.demux();
    }

    private void demux() {
        EbmlUint ts = (EbmlUint)MKVType.findFirst(this.t, MKVType.Segment, MKVType.Info, MKVType.TimecodeScale);
        if (ts != null) {
            this.timescale = ts.get();
        }
        for (EbmlMaster aTrack : MKVType.findList(this.t, EbmlMaster.class, MKVType.Segment, MKVType.Tracks, MKVType.TrackEntry)) {
            long type = ((EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.TrackType)).get();
            long id = ((EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.TrackNumber)).get();
            if (type == 1L) {
                if (this.vTrack != null) {
                    throw new RuntimeException("More then 1 video track, can not compute...");
                }
                EbmlBin videoCodecState = (EbmlBin)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.CodecPrivate);
                ByteBuffer state = null;
                if (videoCodecState != null) {
                    state = videoCodecState.data;
                }
                EbmlUint width = (EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Video, MKVType.PixelWidth);
                EbmlUint height = (EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Video, MKVType.PixelHeight);
                EbmlUint dwidth = (EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Video, MKVType.DisplayWidth);
                EbmlUint dheight = (EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Video, MKVType.DisplayHeight);
                EbmlUint unit = (EbmlUint)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Video, MKVType.DisplayUnit);
                if (width != null && height != null) {
                    this.pictureWidth = (int)width.get();
                    this.pictureHeight = (int)height.get();
                } else if (dwidth != null && dheight != null) {
                    if (unit == null || unit.get() == 0L) {
                        this.pictureHeight = (int)dheight.get();
                        this.pictureWidth = (int)dwidth.get();
                    } else {
                        throw new RuntimeException("DisplayUnits other then 0 are not implemented yet");
                    }
                }
                this.vTrack = new VideoTrack((int)id, state);
                continue;
            }
            if (type != 2L) continue;
            AudioTrack audioTrack = new AudioTrack((int)id);
            EbmlFloat sf = (EbmlFloat)MKVType.findFirst(aTrack, MKVType.TrackEntry, MKVType.Audio, MKVType.SamplingFrequency);
            if (sf != null) {
                audioTrack.samplingFrequency = sf.get();
            }
            this.aTracks.add(audioTrack);
        }
        for (EbmlMaster aCluster : MKVType.findList(this.t, EbmlMaster.class, MKVType.Segment, MKVType.Cluster)) {
            long baseTimecode = ((EbmlUint)MKVType.findFirst(aCluster, MKVType.Cluster, MKVType.Timecode)).get();
            for (EbmlBase child : aCluster.children) {
                if (MKVType.SimpleBlock.equals((Object)child.type)) {
                    MkvBlock b = (MkvBlock)child;
                    b.absoluteTimecode = (long)b.timecode + baseTimecode;
                    this.putIntoRightBasket(b);
                    continue;
                }
                if (!MKVType.BlockGroup.equals((Object)child.type)) continue;
                EbmlMaster group = (EbmlMaster)child;
                for (EbmlBase grandChild : group.children) {
                    if (!MKVType.Block.equals(grandChild)) continue;
                    MkvBlock b = (MkvBlock)child;
                    b.absoluteTimecode = (long)b.timecode + baseTimecode;
                    this.putIntoRightBasket(b);
                }
            }
        }
    }

    private void putIntoRightBasket(MkvBlock b) {
        if (b.trackNumber == (long)this.vTrack.trackNo) {
            this.vTrack.blocks.add(b);
        } else {
            for (int i = 0; i < this.aTracks.size(); ++i) {
                AudioTrack audio = (AudioTrack)this.aTracks.get(i);
                if (b.trackNumber != (long)audio.trackNo) continue;
                audio.blocks.add(IndexedBlock.make(audio.framesCount, b));
                audio.framesCount += b.frameSizes.length;
            }
        }
    }

    public static MKVDemuxer getDemuxer(SeekableByteChannel channel) throws IOException {
        MKVParser parser = new MKVParser(channel);
        return new MKVDemuxer(parser.parse(), channel);
    }

    public DemuxerTrack getVideoTrack() {
        return this.vTrack;
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    public List<DemuxerTrack> getAudioTracks() {
        return this.aTracks;
    }

    public class AudioTrack
    implements SeekableDemuxerTrack {
        public double samplingFrequency;
        public final int trackNo;
        List<IndexedBlock> blocks = new ArrayList<IndexedBlock>();
        private int framesCount = 0;
        private int frameIdx = 0;
        private int blockIdx = 0;
        private int frameInBlockIdx = 0;

        public AudioTrack(int trackNo) {
            this.trackNo = trackNo;
        }

        @Override
        public Packet nextFrame() throws IOException {
            ByteBuffer data;
            if (this.frameIdx > this.blocks.size()) {
                return null;
            }
            MkvBlock b = this.blocks.get((int)this.blockIdx).block;
            if (b == null) {
                throw new RuntimeException("Something somewhere went wrong.");
            }
            if (b.frames == null || b.frames.length == 0) {
                MKVDemuxer.this.channel.position(b.dataOffset);
                data = ByteBuffer.allocate(b.dataLen);
                MKVDemuxer.this.channel.read(data);
                b.readFrames(data);
            }
            data = b.frames[this.frameInBlockIdx].duplicate();
            ++this.frameInBlockIdx;
            ++this.frameIdx;
            if (this.frameInBlockIdx >= b.frames.length) {
                ++this.blockIdx;
                this.frameInBlockIdx = 0;
            }
            return new Packet(data, b.absoluteTimecode, Math.round(this.samplingFrequency), 1L, 0L, false, ZERO_TAPE_TIMECODE);
        }

        @Override
        public boolean gotoFrame(long i) {
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            if (i > (long)this.framesCount) {
                return false;
            }
            int frameBlockIdx = this.findBlockIndex(i);
            if (frameBlockIdx == -1) {
                return false;
            }
            this.frameIdx = (int)i;
            this.blockIdx = frameBlockIdx;
            this.frameInBlockIdx = (int)i - this.blocks.get((int)this.blockIdx).firstFrameNo;
            return true;
        }

        private int findBlockIndex(long i) {
            for (int blockIndex = 0; blockIndex < this.blocks.size(); ++blockIndex) {
                if (i < (long)this.blocks.get((int)blockIndex).block.frameSizes.length) {
                    return blockIndex;
                }
                i -= (long)this.blocks.get((int)blockIndex).block.frameSizes.length;
            }
            return -1;
        }

        @Override
        public long getCurFrame() {
            return this.frameIdx;
        }

        @Override
        public void seek(double second) {
            throw new RuntimeException("Not implemented yet");
        }

        public Packet getFrames(int count) {
            ByteBuffer data;
            if (count + this.frameIdx >= this.framesCount) {
                return null;
            }
            ArrayList<ByteBuffer> packetFrames = new ArrayList<ByteBuffer>();
            MkvBlock firstBlockInAPacket = this.blocks.get((int)this.blockIdx).block;
            while (count > 0) {
                MkvBlock b = this.blocks.get((int)this.blockIdx).block;
                if (b.frames == null || b.frames.length == 0) {
                    try {
                        MKVDemuxer.this.channel.position(b.dataOffset);
                        data = ByteBuffer.allocate(b.dataLen);
                        MKVDemuxer.this.channel.read(data);
                        b.readFrames(data);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("while reading frames of a Block at offset 0x" + Long.toHexString(b.dataOffset).toUpperCase() + ")", ioe);
                    }
                }
                packetFrames.add(b.frames[this.frameInBlockIdx].duplicate());
                ++this.frameIdx;
                ++this.frameInBlockIdx;
                if (this.frameInBlockIdx >= b.frames.length) {
                    this.frameInBlockIdx = 0;
                    ++this.blockIdx;
                }
                --count;
            }
            int size = 0;
            for (ByteBuffer aFrame : packetFrames) {
                size += aFrame.limit();
            }
            data = ByteBuffer.allocate(size);
            for (ByteBuffer aFrame : packetFrames) {
                data.put(aFrame);
            }
            return new Packet(data, firstBlockInAPacket.absoluteTimecode, Math.round(this.samplingFrequency), packetFrames.size(), 0L, false, ZERO_TAPE_TIMECODE);
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            throw new RuntimeException("Unsupported");
        }

        @Override
        public boolean gotoSyncFrame(long frame) {
            return this.gotoFrame(frame);
        }
    }

    public static class IndexedBlock {
        public int firstFrameNo;
        public MkvBlock block;

        public static IndexedBlock make(int no, MkvBlock b) {
            IndexedBlock ib = new IndexedBlock();
            ib.firstFrameNo = no;
            ib.block = b;
            return ib;
        }
    }

    public class VideoTrack
    implements SeekableDemuxerTrack {
        private ByteBuffer state;
        public final int trackNo;
        private int frameIdx = 0;
        List<MkvBlock> blocks = new ArrayList<MkvBlock>();

        public VideoTrack(int trackNo, ByteBuffer state) {
            this.trackNo = trackNo;
            this.state = state;
        }

        @Override
        public Packet nextFrame() throws IOException {
            if (this.frameIdx >= this.blocks.size()) {
                return null;
            }
            MkvBlock b = this.blocks.get(this.frameIdx);
            if (b == null) {
                throw new RuntimeException("Something somewhere went wrong.");
            }
            ++this.frameIdx;
            MKVDemuxer.this.channel.position(b.dataOffset);
            ByteBuffer data = ByteBuffer.allocate(b.dataLen);
            MKVDemuxer.this.channel.read(data);
            data.flip();
            b.readFrames(data.duplicate());
            long duration = 1L;
            if (this.frameIdx < this.blocks.size()) {
                duration = this.blocks.get((int)this.frameIdx).absoluteTimecode - b.absoluteTimecode;
            }
            return new Packet(b.frames[0].duplicate(), b.absoluteTimecode, MKVDemuxer.this.timescale, duration, this.frameIdx - 1, b.keyFrame, ZERO_TAPE_TIMECODE);
        }

        @Override
        public boolean gotoFrame(long i) {
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            if (i > (long)this.blocks.size()) {
                return false;
            }
            this.frameIdx = (int)i;
            return true;
        }

        @Override
        public long getCurFrame() {
            return this.frameIdx;
        }

        @Override
        public void seek(double second) {
            throw new RuntimeException("Not implemented yet");
        }

        public int getFrameCount() {
            return this.blocks.size();
        }

        public ByteBuffer getCodecState() {
            return this.state;
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            throw new RuntimeException("Unsupported");
        }

        @Override
        public boolean gotoSyncFrame(long i) {
            throw new RuntimeException("Unsupported");
        }
    }
}

