/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;

public class ByteBufferSeekableByteChannel
implements SeekableByteChannel {
    private ByteBuffer backing;
    private boolean open;
    private int contentLength;

    public ByteBufferSeekableByteChannel(ByteBuffer backing) {
        this.backing = backing;
        this.open = true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.backing.hasRemaining()) {
            return -1;
        }
        int toRead = Math.min(this.backing.remaining(), dst.remaining());
        dst.put(NIOUtils.read(this.backing, toRead));
        this.contentLength = Math.max(this.contentLength, this.backing.position());
        return toRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int toWrite = Math.min(this.backing.remaining(), src.remaining());
        this.backing.put(NIOUtils.read(src, toWrite));
        this.contentLength = Math.max(this.contentLength, this.backing.position());
        return toWrite;
    }

    @Override
    public long position() throws IOException {
        return this.backing.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.backing.position((int)newPosition);
        this.contentLength = Math.max(this.contentLength, this.backing.position());
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.contentLength;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.contentLength = (int)size;
        return this;
    }

    public ByteBuffer getContents() {
        ByteBuffer contents = this.backing.duplicate();
        contents.position(0);
        contents.limit(this.contentLength);
        return contents;
    }
}

