/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.audio;

import java.nio.FloatBuffer;
import java.util.Arrays;
import org.jcodec.audio.Audio;
import org.jcodec.audio.AudioFilter;

public class FilterSocket {
    private FloatBuffer[] buffers;
    private long[] positions;
    private int[] delays;
    private AudioFilter[] filters;
    private int totalInputs;
    private int totalOutputs;

    public FilterSocket(AudioFilter ... filters) {
        int i;
        this.totalInputs = 0;
        this.totalOutputs = 0;
        for (i = 0; i < filters.length; ++i) {
            this.totalInputs += filters[i].getNInputs();
            this.totalOutputs += filters[i].getNOutputs();
        }
        this.buffers = new FloatBuffer[this.totalInputs];
        this.positions = new long[this.totalInputs];
        this.delays = new int[this.totalInputs];
        int b = 0;
        for (i = 0; i < filters.length; ++i) {
            int j = 0;
            while (j < filters[i].getNInputs()) {
                this.delays[b] = filters[i].getDelay();
                ++j;
                ++b;
            }
        }
        this.filters = filters;
    }

    public void allocateBuffers(int bufferSize) {
        for (int i = 0; i < this.totalInputs; ++i) {
            this.buffers[i] = FloatBuffer.allocate(bufferSize + this.delays[i] * 2);
            this.buffers[i].position(this.delays[i]);
        }
    }

    FilterSocket(AudioFilter filter, FloatBuffer[] buffers, long[] positions) {
        this.filters = new AudioFilter[]{filter};
        this.buffers = buffers;
        this.positions = positions;
        this.delays = new int[]{filter.getDelay()};
        this.totalInputs = filter.getNInputs();
        this.totalOutputs = filter.getNOutputs();
    }

    public void filter(FloatBuffer[] outputs) {
        if (outputs.length != this.totalOutputs) {
            throw new IllegalArgumentException("Can not output to provided filter socket inputs != outputs (" + outputs.length + "!=" + this.totalOutputs + ")");
        }
        int ii = 0;
        int oi = 0;
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].filter(Arrays.copyOfRange(this.buffers, ii, this.filters[i].getNInputs() + ii), Arrays.copyOfRange(this.positions, ii, this.filters[i].getNInputs() + ii), Arrays.copyOfRange(outputs, oi, this.filters[i].getNOutputs() + oi));
            ii += this.filters[i].getNInputs();
            oi += this.filters[i].getNOutputs();
        }
    }

    FloatBuffer[] getBuffers() {
        return this.buffers;
    }

    public void rotate() {
        for (int i = 0; i < this.buffers.length; ++i) {
            int n = i;
            this.positions[n] = this.positions[n] + (long)this.buffers[i].position();
            Audio.rotate(this.buffers[i]);
        }
    }

    public void setBuffers(FloatBuffer[] ins, long[] pos) {
        if (ins.length != this.totalInputs) {
            throw new IllegalArgumentException("Number of input buffers provided is less then the number of filter inputs.");
        }
        if (pos.length != this.totalInputs) {
            throw new IllegalArgumentException("Number of input buffer positions provided is less then the number of filter inputs.");
        }
        this.buffers = ins;
        this.positions = pos;
    }

    public int getTotalInputs() {
        return this.totalInputs;
    }

    public int getTotalOutputs() {
        return this.totalOutputs;
    }

    AudioFilter[] getFilters() {
        return this.filters;
    }

    public long[] getPositions() {
        return this.positions;
    }
}

