/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photosets;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.people.User;
import com.flickr4java.flickr.photos.Extras;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoContext;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.photosets.Photoset;
import com.flickr4java.flickr.photosets.Photosets;
import com.flickr4java.flickr.util.StringUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PhotosetsInterface {
    private static Logger _log = Logger.getLogger(PhotosetsInterface.class);
    public static final String METHOD_ADD_PHOTO = "flickr.photosets.addPhoto";
    public static final String METHOD_CREATE = "flickr.photosets.create";
    public static final String METHOD_DELETE = "flickr.photosets.delete";
    public static final String METHOD_EDIT_META = "flickr.photosets.editMeta";
    public static final String METHOD_EDIT_PHOTOS = "flickr.photosets.editPhotos";
    public static final String METHOD_GET_CONTEXT = "flickr.photosets.getContext";
    public static final String METHOD_GET_INFO = "flickr.photosets.getInfo";
    public static final String METHOD_GET_LIST = "flickr.photosets.getList";
    public static final String METHOD_GET_PHOTOS = "flickr.photosets.getPhotos";
    public static final String METHOD_ORDER_SETS = "flickr.photosets.orderSets";
    public static final String METHOD_REMOVE_PHOTO = "flickr.photosets.removePhoto";
    public static final String METHOD_REMOVE_PHOTOS = "flickr.photosets.removePhotos";
    public static final String METHOD_REORDER_PHOTOS = "flickr.photosets.reorderPhotos";
    public static final String METHOD_SET_PRIMARY_PHOTO = "flickr.photosets.setPrimaryPhoto";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public PhotosetsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public void addPhoto(String photosetId, String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_ADD_PHOTO);
        parameters.put("photoset_id", photosetId);
        parameters.put("photo_id", photoId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public Photoset create(String title, String description, String primaryPhotoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_CREATE);
        parameters.put("title", title);
        parameters.put("description", description);
        parameters.put("primary_photo_id", primaryPhotoId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosetElement = response.getPayload();
        Photoset photoset = new Photoset();
        photoset.setId(photosetElement.getAttribute("id"));
        photoset.setUrl(photosetElement.getAttribute("url"));
        return photoset;
    }

    public void delete(String photosetId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_DELETE);
        parameters.put("photoset_id", photosetId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void editMeta(String photosetId, String title, String description) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_EDIT_META);
        parameters.put("photoset_id", photosetId);
        parameters.put("title", title);
        if (description != null) {
            parameters.put("description", description);
        }
        if ((response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void editPhotos(String photosetId, String primaryPhotoId, String[] photoIds) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_EDIT_PHOTOS);
        parameters.put("photoset_id", photosetId);
        parameters.put("primary_photo_id", primaryPhotoId);
        parameters.put("photo_ids", StringUtilities.join(photoIds, ","));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public PhotoContext getContext(String photoId, String photosetId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CONTEXT);
        parameters.put("photo_id", photoId);
        parameters.put("photoset_id", photosetId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Collection<Element> payload = response.getPayloadCollection();
        PhotoContext photoContext = new PhotoContext();
        for (Element element : payload) {
            Photo photo;
            String elementName = element.getTagName();
            if (elementName.equals("prevphoto")) {
                photo = new Photo();
                photo.setId(element.getAttribute("id"));
                photoContext.setPreviousPhoto(photo);
                continue;
            }
            if (elementName.equals("nextphoto")) {
                photo = new Photo();
                photo.setId(element.getAttribute("id"));
                photoContext.setNextPhoto(photo);
                continue;
            }
            if (elementName.equals("count")) continue;
            _log.warn((Object)("unsupported element name: " + elementName));
        }
        return photoContext;
    }

    public Photoset getInfo(String photosetId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        parameters.put("photoset_id", photosetId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosetElement = response.getPayload();
        Photoset photoset = new Photoset();
        photoset.setId(photosetElement.getAttribute("id"));
        User owner = new User();
        owner.setId(photosetElement.getAttribute("owner"));
        photoset.setOwner(owner);
        Photo primaryPhoto = new Photo();
        primaryPhoto.setId(photosetElement.getAttribute("primary"));
        primaryPhoto.setSecret(photosetElement.getAttribute("secret"));
        primaryPhoto.setServer(photosetElement.getAttribute("server"));
        primaryPhoto.setFarm(photosetElement.getAttribute("farm"));
        photoset.setPrimaryPhoto(primaryPhoto);
        photoset.setSecret(photosetElement.getAttribute("secret"));
        photoset.setServer(photosetElement.getAttribute("server"));
        photoset.setFarm(photosetElement.getAttribute("farm"));
        photoset.setPhotoCount(photosetElement.getAttribute("count_photos"));
        photoset.setVideoCount(Integer.parseInt(photosetElement.getAttribute("count_videos")));
        photoset.setViewCount(Integer.parseInt(photosetElement.getAttribute("count_views")));
        photoset.setCommentCount(Integer.parseInt(photosetElement.getAttribute("count_comments")));
        photoset.setDateCreate(photosetElement.getAttribute("date_create"));
        photoset.setDateUpdate(photosetElement.getAttribute("date_update"));
        photoset.setIsCanComment("1".equals(photosetElement.getAttribute("can_comment")));
        photoset.setTitle(XMLUtilities.getChildValue(photosetElement, "title"));
        photoset.setDescription(XMLUtilities.getChildValue(photosetElement, "description"));
        photoset.setPrimaryPhoto(primaryPhoto);
        return photoset;
    }

    public Photosets getList(String userId) throws FlickrException {
        return this.getList(userId, 0, 0, null);
    }

    public Photosets getList(String userId, String primaryPhotoExtras) throws FlickrException {
        return this.getList(userId, 0, 0, primaryPhotoExtras);
    }

    public Photosets getList(String userId, int perPage, int page, String primaryPhotoExtras) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        if (userId != null) {
            parameters.put("user_id", userId);
        }
        if (perPage > 0) {
            parameters.put("per_page", String.valueOf(perPage));
        }
        if (page > 0) {
            parameters.put("page", String.valueOf(page));
        }
        if (primaryPhotoExtras != null) {
            parameters.put("primary_photo_extras", primaryPhotoExtras);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Photosets photosetsObject = new Photosets();
        Element photosetsElement = response.getPayload();
        photosetsObject.setCanCreate(XMLUtilities.getBooleanAttribute(photosetsElement, "cancreate"));
        photosetsObject.setPage(XMLUtilities.getIntAttribute(photosetsElement, "page"));
        photosetsObject.setPages(XMLUtilities.getIntAttribute(photosetsElement, "pages"));
        photosetsObject.setPerPage(XMLUtilities.getIntAttribute(photosetsElement, "perpage"));
        photosetsObject.setTotal(XMLUtilities.getIntAttribute(photosetsElement, "total"));
        ArrayList<Photoset> photosets = new ArrayList<Photoset>();
        NodeList photosetElements = photosetsElement.getElementsByTagName("photoset");
        for (int i = 0; i < photosetElements.getLength(); ++i) {
            Element photosetElement = (Element)photosetElements.item(i);
            Photoset photoset = new Photoset();
            photoset.setId(photosetElement.getAttribute("id"));
            User owner = new User();
            owner.setId(photosetElement.getAttribute("owner"));
            photoset.setOwner(owner);
            Element primaryPhotoExtrasEl = XMLUtilities.getChild(photosetElement, "primary_photo_extras");
            Photo primaryPhoto = primaryPhotoExtrasEl != null ? PhotoUtils.createPhoto(primaryPhotoExtrasEl) : new Photo();
            primaryPhoto.setId(photosetElement.getAttribute("primary"));
            primaryPhoto.setSecret(photosetElement.getAttribute("secret"));
            primaryPhoto.setServer(photosetElement.getAttribute("server"));
            primaryPhoto.setFarm(photosetElement.getAttribute("farm"));
            photoset.setPrimaryPhoto(primaryPhoto);
            photoset.setSecret(photosetElement.getAttribute("secret"));
            photoset.setServer(photosetElement.getAttribute("server"));
            photoset.setFarm(photosetElement.getAttribute("farm"));
            photoset.setPhotoCount(photosetElement.getAttribute("photos"));
            photoset.setVideoCount(Integer.parseInt(photosetElement.getAttribute("videos")));
            photoset.setViewCount(Integer.parseInt(photosetElement.getAttribute("count_views")));
            photoset.setCommentCount(Integer.parseInt(photosetElement.getAttribute("count_comments")));
            photoset.setDateCreate(photosetElement.getAttribute("date_create"));
            photoset.setDateUpdate(photosetElement.getAttribute("date_update"));
            photoset.setIsCanComment("1".equals(photosetElement.getAttribute("can_comment")));
            photoset.setIsNeedsInterstitial("1".equals(photosetElement.getAttribute("needs_interstitial")));
            photoset.setIsVisible("1".equals(photosetElement.getAttribute("visibility_can_see_set")));
            photoset.setDescription(XMLUtilities.getChildValue(photosetElement, "description"));
            photoset.setTitle(XMLUtilities.getChildValue(photosetElement, "title"));
            photoset.setDescription(XMLUtilities.getChildValue(photosetElement, "description"));
            photosets.add(photoset);
        }
        photosetsObject.setPhotosets(photosets);
        return photosetsObject;
    }

    public int getPhotosetCount(String userId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        if (userId != null) {
            parameters.put("user_id", userId);
        }
        parameters.put("per_page", String.valueOf(1));
        parameters.put("page", String.valueOf(1));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosetsElement = response.getPayload();
        return Integer.valueOf(photosetsElement.getAttribute("total"));
    }

    public PhotoList<Photo> getPhotos(String photosetId, Set<String> extras, int privacy_filter, int perPage, int page) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PHOTOS);
        parameters.put("photoset_id", photosetId);
        if (perPage > 0) {
            parameters.put("per_page", String.valueOf(perPage));
        }
        if (page > 0) {
            parameters.put("page", String.valueOf(page));
        }
        if (privacy_filter > 0) {
            parameters.put("privacy_filter", "" + privacy_filter);
        }
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photoset = response.getPayload();
        NodeList photoElements = photoset.getElementsByTagName("photo");
        photos.setPage(photoset.getAttribute("page"));
        photos.setPages(photoset.getAttribute("pages"));
        photos.setPerPage(photoset.getAttribute("per_page"));
        photos.setTotal(photoset.getAttribute("total"));
        for (int i = 0; i < photoElements.getLength(); ++i) {
            Element photoElement = (Element)photoElements.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement, photoset));
        }
        return photos;
    }

    public PhotoList<Photo> getPhotos(String photosetId, int perPage, int page) throws FlickrException {
        return this.getPhotos(photosetId, Extras.MIN_EXTRAS, 0, perPage, page);
    }

    public void orderSets(String[] photosetIds) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_ORDER_SETS);
        parameters.put("photoset_ids", StringUtilities.join(photosetIds, ","));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void removePhoto(String photosetId, String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_REMOVE_PHOTO);
        parameters.put("photoset_id", photosetId);
        parameters.put("photo_id", photoId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void removePhotos(String photosetId, String photoIds) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_REMOVE_PHOTOS);
        parameters.put("photoset_id", photosetId);
        parameters.put("photo_ids", photoIds);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void reorderPhotos(String photosetId, String photoIds) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_REORDER_PHOTOS);
        parameters.put("photoset_id", photosetId);
        parameters.put("photo_ids", photoIds);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setPrimaryPhoto(String photosetId, String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_PRIMARY_PHOTO);
        parameters.put("photoset_id", photosetId);
        parameters.put("photo_id", photoId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

