/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.people;

import com.flickr4java.flickr.contacts.OnlineStatus;
import com.flickr4java.flickr.people.PhotoLimits;
import com.flickr4java.flickr.people.TimeZone;
import com.flickr4java.flickr.people.VideoLimits;
import com.flickr4java.flickr.util.BuddyIconable;
import com.flickr4java.flickr.util.UrlUtilities;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class User
implements Serializable,
BuddyIconable {
    private static final long serialVersionUID = 12L;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private String id;
    private String username;
    private boolean admin;
    private boolean pro;
    private int iconFarm;
    private int iconServer;
    private String realName;
    private String location;
    private TimeZone timeZone;
    private Date photosFirstDate;
    private Date photosFirstDateTaken;
    private Date faveDate;
    private int photosCount;
    private OnlineStatus online;
    private String awayMessage;
    private long bandwidthMax;
    private long bandwidthUsed;
    private Boolean bandwidthUnlimited;
    private String setsCreated;
    private String setsRemaining;
    private String videosUploaded;
    private String videosRemaining;
    private String videoSizeMax;
    private long filesizeMax;
    private String mbox_sha1sum;
    private String photosurl;
    private String profileurl;
    private String mobileurl;
    private boolean revContact;
    private boolean revFriend;
    private boolean revFamily;
    private String pathAlias;
    private PhotoLimits photoLimits;
    private VideoLimits videoLimits;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isPro() {
        return this.pro;
    }

    public void setPro(boolean pro) {
        this.pro = pro;
    }

    @Override
    public int getIconFarm() {
        return this.iconFarm;
    }

    @Override
    public void setIconFarm(int iconFarm) {
        this.iconFarm = iconFarm;
    }

    @Override
    public void setIconFarm(String iconFarm) {
        if (iconFarm != null) {
            this.setIconFarm(Integer.parseInt(iconFarm));
        }
    }

    @Override
    public int getIconServer() {
        return this.iconServer;
    }

    @Override
    public void setIconServer(int iconServer) {
        this.iconServer = iconServer;
    }

    @Override
    public void setIconServer(String iconServer) {
        if (iconServer != null) {
            this.setIconServer(Integer.parseInt(iconServer));
        }
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public TimeZone setTimeZone(TimeZone string) {
        this.timeZone = string;
        return this.timeZone;
    }

    @Override
    @Deprecated
    public String getBuddyIconUrl() {
        return UrlUtilities.createBuddyIconUrl(this.iconFarm, this.iconServer, this.id);
    }

    public String getLocation() {
        return this.location;
    }

    public String getSecureBuddyIconUrl() {
        return UrlUtilities.createSecureBuddyIconUrl(this.iconFarm, this.iconServer, this.id);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getPhotosFirstDate() {
        return this.photosFirstDate;
    }

    public void setPhotosFirstDate(Date photosFirstDate) {
        this.photosFirstDate = photosFirstDate;
    }

    public void setPhotosFirstDate(long photosFirstDate) {
        this.setPhotosFirstDate(new Date(photosFirstDate));
    }

    public void setPhotosFirstDate(String photosFirstDate) {
        if (photosFirstDate != null) {
            this.setPhotosFirstDate(Long.parseLong(photosFirstDate) * 1000L);
        }
    }

    public Date getPhotosFirstDateTaken() {
        return this.photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(Date photosFirstDateTaken) {
        this.photosFirstDateTaken = photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(String photosFirstDateTaken) {
        if (photosFirstDateTaken != null) {
            try {
                this.setPhotosFirstDateTaken(((DateFormat)DATE_FORMATS.get()).parse(photosFirstDateTaken));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setFaveDate(String faveDate) {
        this.setFaveDate(Long.parseLong(faveDate) * 1000L);
    }

    public void setFaveDate(long faveDate) {
        this.setFaveDate(new Date(faveDate));
    }

    public void setFaveDate(Date faveDate) {
        this.faveDate = faveDate;
    }

    public Date getFaveDate() {
        return this.faveDate;
    }

    public int getPhotosCount() {
        return this.photosCount;
    }

    public void setPhotosCount(int photosCount) {
        this.photosCount = photosCount;
    }

    public void setPhotosCount(String photosCount) {
        if (photosCount != null) {
            this.setPhotosCount(Integer.parseInt(photosCount));
        }
    }

    public OnlineStatus getOnline() {
        return this.online;
    }

    public void setOnline(OnlineStatus online) {
        this.online = online;
    }

    public String getAwayMessage() {
        return this.awayMessage;
    }

    public void setAwayMessage(String awayMessage) {
        this.awayMessage = awayMessage;
    }

    public long getBandwidthMax() {
        return this.bandwidthMax;
    }

    public void setBandwidthMax(long bandwidthMax) {
        this.bandwidthMax = bandwidthMax;
    }

    public void setBandwidthMax(String bandwidthMax) {
        if (bandwidthMax != null) {
            this.setBandwidthMax(Long.parseLong(bandwidthMax));
        }
    }

    public long getBandwidthUsed() {
        return this.bandwidthUsed;
    }

    public void setBandwidthUsed(long bandwidthUsed) {
        this.bandwidthUsed = bandwidthUsed;
    }

    public void setBandwidthUsed(String bandwidthUsed) {
        if (bandwidthUsed != null) {
            this.setBandwidthUsed(Long.parseLong(bandwidthUsed));
        }
    }

    public long getFilesizeMax() {
        return this.filesizeMax;
    }

    public void setFilesizeMax(long filesizeMax) {
        this.filesizeMax = filesizeMax;
    }

    public void setFilesizeMax(String filesizeMax) {
        if (filesizeMax != null) {
            this.setFilesizeMax(Long.parseLong(filesizeMax));
        }
    }

    public void setMbox_sha1sum(String mbox_sha1sum) {
        this.mbox_sha1sum = mbox_sha1sum;
    }

    public String getMbox_sha1sum() {
        return this.mbox_sha1sum;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        User test = (User)obj;
        return this.id == null ? test.id == null : this.id.equals(test.id);
    }

    public int hashCode() {
        int hash = 83;
        if (this.id != null) {
            hash ^= this.id.hashCode();
        }
        return hash;
    }

    public String getPhotosurl() {
        return this.photosurl;
    }

    public void setPhotosurl(String photosurl) {
        this.photosurl = photosurl;
    }

    public String getProfileurl() {
        return this.profileurl;
    }

    public void setProfileurl(String profileurl) {
        this.profileurl = profileurl;
    }

    public String getMobileurl() {
        return this.mobileurl;
    }

    public void setMobileurl(String mobileurl) {
        this.mobileurl = mobileurl;
    }

    public void setRevContact(boolean revContact) {
        this.revContact = revContact;
    }

    public boolean isRevContact() {
        return this.revContact;
    }

    public void setRevFriend(boolean revFriend) {
        this.revFriend = revFriend;
    }

    public boolean isRevFriend() {
        return this.revFriend;
    }

    public void setRevFamily(boolean revFamily) {
        this.revFamily = revFamily;
    }

    public boolean isRevFamily() {
        return this.revFamily;
    }

    public String getPathAlias() {
        return this.pathAlias;
    }

    public void setPathAlias(String pathAlias) {
        this.pathAlias = pathAlias;
    }

    public PhotoLimits getPhotoLimits() {
        return this.photoLimits;
    }

    public void setPhotoLimits(PhotoLimits photoLimits) {
        this.photoLimits = photoLimits;
    }

    public VideoLimits getVideoLimits() {
        return this.videoLimits;
    }

    public void setPhotoLimits(VideoLimits videoLimits) {
        this.videoLimits = videoLimits;
    }

    public Boolean isBandwidthUnlimited() {
        return this.bandwidthUnlimited;
    }

    public void setIsBandwidthUnlimited(Boolean bandwidthUnlimited) {
        this.bandwidthUnlimited = bandwidthUnlimited;
    }

    public String getSetsCreated() {
        return this.setsCreated;
    }

    public void setSetsCreated(String setsCreated) {
        this.setsCreated = setsCreated;
    }

    public String getSetsRemaining() {
        return this.setsRemaining;
    }

    public void setSetsRemaining(String setsRemaining) {
        this.setsRemaining = setsRemaining;
    }

    public String getVideosUploaded() {
        return this.videosUploaded;
    }

    public void setVideosUploaded(String videosUploaded) {
        this.videosUploaded = videosUploaded;
    }

    public String getVideosRemaining() {
        return this.videosRemaining;
    }

    public void setVideosRemaining(String videosRemaining) {
        this.videosRemaining = videosRemaining;
    }

    public String getVideosSizeMax() {
        return this.videoSizeMax;
    }

    public void setVideoSizeMax(String videoSizeMax) {
        this.videoSizeMax = videoSizeMax;
    }
}

