/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.panda;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.panda.Panda;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.util.StringUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PandaInterface {
    private static final String METHOD_GET_PHOTOS = "flickr.panda.getPhotos";
    private static final String METHOD_GET_LIST = "flickr.panda.getList";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public PandaInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public ArrayList<Panda> getList() throws FlickrException {
        ArrayList<Panda> pandas = new ArrayList<Panda>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element pandaElement = response.getPayload();
        NodeList pandaNodes = pandaElement.getElementsByTagName("panda");
        for (int i = 0; i < pandaNodes.getLength(); ++i) {
            pandaElement = (Element)pandaNodes.item(i);
            Panda panda = new Panda();
            panda.setName(XMLUtilities.getValue(pandaElement));
            pandas.add(panda);
        }
        return pandas;
    }

    public PhotoList<Photo> getPhotos(Panda panda, Set<String> extras, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PHOTOS);
        parameters.put("panda_name", panda.getName());
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }
}

