/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.auth;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.auth.Auth;
import com.flickr4java.flickr.auth.Permission;
import com.flickr4java.flickr.people.User;
import com.flickr4java.flickr.util.ByteUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.FlickrApi;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.w3c.dom.Element;

public class AuthInterface {
    private static final String OUT_OF_BOUND_AUTH_METHOD = "oob";
    private static final String METHOD_CHECK_TOKEN = "flickr.auth.oauth.checkToken";
    private static final String METHOD_EXCHANGE_TOKEN = "flickr.auth.oauth.getAccessToken";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;
    private static final Logger logger = Logger.getLogger(AuthInterface.class);
    private int maxGetTokenRetries = 3;

    public AuthInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transport;
    }

    public Token getRequestToken() {
        return this.getRequestToken(null);
    }

    public Token getRequestToken(String callbackUrl) {
        String callback = callbackUrl != null ? callbackUrl : OUT_OF_BOUND_AUTH_METHOD;
        OAuthService service = new ServiceBuilder().provider(FlickrApi.class).apiKey(this.apiKey).apiSecret(this.sharedSecret).callback(callback).build();
        return service.getRequestToken();
    }

    public String getAuthorizationUrl(Token oAuthRequestToken, Permission permission) {
        OAuthService service = new ServiceBuilder().provider(FlickrApi.class).apiKey(this.apiKey).apiSecret(this.sharedSecret).build();
        String authorizationUrl = service.getAuthorizationUrl(oAuthRequestToken);
        return String.format("%s&perms=%s", authorizationUrl, permission.toString());
    }

    public Token getAccessToken(Token oAuthRequestToken, Verifier verifier) {
        OAuthService service = new ServiceBuilder().provider(FlickrApi.class).apiKey(this.apiKey).apiSecret(this.sharedSecret).build();
        Token accessToken = null;
        boolean success = false;
        for (int i = 0; i < this.maxGetTokenRetries && !success; ++i) {
            try {
                accessToken = service.getAccessToken(oAuthRequestToken, verifier);
                success = true;
                continue;
            }
            catch (OAuthException e) {
                if (i == this.maxGetTokenRetries) {
                    logger.error((Object)String.format("OAuthService.getAccessToken failing after %d tries, re-throwing exception", i), (Throwable)e);
                    throw e;
                }
                logger.warn((Object)String.format("OAuthService.getAccessToken failed, try number %d: %s", i, e.getMessage()));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        assert (accessToken != null);
        assert (success);
        return accessToken;
    }

    public Auth checkToken(Token accessToken) throws FlickrException {
        return this.checkToken(accessToken.getToken(), accessToken.getSecret());
    }

    public Auth checkToken(String authToken, String tokenSecret) throws FlickrException {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("method", METHOD_CHECK_TOKEN);
        parameters.put("oauth_token", authToken);
        parameters.put("api_key", this.apiKey);
        parameters.put("api_sig", this.getSignature(this.sharedSecret, parameters));
        Response response = this.transportAPI.getNonOAuth(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Auth auth = this.constructAuth(response, authToken, tokenSecret);
        return auth;
    }

    public Token exchangeAuthToken(String authToken) throws FlickrException {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("method", METHOD_EXCHANGE_TOKEN);
        parameters.put("api_key", this.apiKey);
        parameters.put("api_sig", this.getSignature(this.sharedSecret, parameters));
        Response response = this.transportAPI.getNonOAuth(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Token accessToken = this.constructToken(response);
        return accessToken;
    }

    private Auth constructAuth(Response response, String authToken, String tokenSecret) {
        Auth auth = new Auth();
        Element authElement = response.getPayload();
        auth.setToken(authToken);
        auth.setTokenSecret(tokenSecret);
        auth.setPermission(Permission.fromString(XMLUtilities.getChildValue(authElement, "perms")));
        Element userElement = XMLUtilities.getChild(authElement, "user");
        User user = new User();
        user.setId(userElement.getAttribute("nsid"));
        user.setUsername(userElement.getAttribute("username"));
        user.setRealName(userElement.getAttribute("fullname"));
        auth.setUser(user);
        return auth;
    }

    private Token constructToken(Response response) {
        Element authElement = response.getPayload();
        String oauthToken = XMLUtilities.getChildValue(authElement, "oauth_token");
        String oauthTokenSecret = XMLUtilities.getChildValue(authElement, "oauth_token_secret");
        Token token = new Token(oauthToken, oauthTokenSecret);
        return token;
    }

    private String getSignature(String sharedSecret, Map<String, String> params) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sharedSecret);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append(entry.getValue());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return ByteUtilities.toHexString(md.digest(buffer.toString().getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    public void setMaxGetTokenRetries(int maxGetTokenRetries) {
        this.maxGetTokenRetries = maxGetTokenRetries;
    }
}

