/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ngs.ngunits.UnitConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnitConverter
implements UnitConverter {
    public static final UnitConverter IDENTITY = new Identity();

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        return unitConverter.isIdentity() ? this : new Compound(unitConverter, this);
    }

    public List<UnitConverter> getCompoundConverters() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitConverter)) {
            return false;
        }
        return this.concatenate(((UnitConverter)object).inverse()) == IDENTITY;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.convert(1.0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Compound
    extends AbstractUnitConverter {
        private final List<UnitConverter> _contents = new ArrayList<UnitConverter>(2);

        Compound(UnitConverter unitConverter, UnitConverter unitConverter2) {
            this._contents.add(unitConverter);
            this._contents.add(unitConverter2);
        }

        @Override
        public boolean isLinear() {
            return this._contents.get(0).isLinear() && this._contents.get(1).isLinear();
        }

        @Override
        public UnitConverter concatenate(UnitConverter unitConverter) {
            if (unitConverter instanceof Compound) {
                Compound compound = (Compound)unitConverter;
                if (this._contents.get(0).equals(compound._contents.get(1).inverse()) && this._contents.get(1).equals(compound._contents.get(0).inverse())) {
                    return IDENTITY;
                }
            }
            return super.concatenate(unitConverter);
        }

        @Override
        public List<UnitConverter> getCompoundConverters() {
            return Collections.unmodifiableList(this._contents);
        }

        @Override
        public UnitConverter inverse() {
            return new Compound(this._contents.get(1).inverse(), this._contents.get(0).inverse());
        }

        @Override
        public double convert(double d) {
            return this._contents.get(1).convert(this._contents.get(0).convert(d));
        }
    }

    public static final class Identity
    extends AbstractUnitConverter {
        Identity() {
        }

        public boolean isIdentity() {
            return true;
        }

        public UnitConverter concatenate(UnitConverter unitConverter) {
            return unitConverter;
        }

        public UnitConverter inverse() {
            return this;
        }

        public double convert(double d) {
            return d;
        }

        public boolean equals(Object object) {
            return object instanceof UnitConverter && ((UnitConverter)object).isIdentity();
        }
    }
}

