/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Color;
import org.nlogo.api.Context;
import org.nlogo.api.LogoException;
import org.nlogo.app.App;
import view25d.View25DExtension;
import view25d.view.LinkValue;
import view25d.view.MouseableGLWindow;
import view25d.view.TurtleValue;
import view25d.view.TurtleViewOptions;
import view25d.view.VarviewWindow;
import view25d.view.gl.TurtleGL;

public class TurtleView
extends VarviewWindow {
    private static final long serialVersionUID = 1L;
    AgentSet myAgents;
    private TurtleGL glManager;
    private AnonymousReporter reporter;
    private AnonymousReporter stemColorReporter = null;
    private double defaultStemColor = 4.5;
    public ArrayList<TurtleValue> turtleReporterValues;
    public ArrayList<LinkValue> linkValues;
    public java.awt.Color[][] patchColorMatrix;
    public TurtleViewOptions viewOptions;

    @Override
    public MouseableGLWindow getGLWindow() {
        return this.glManager;
    }

    public TurtleView(String title, AgentSet set, AnonymousReporter rt) {
        super(title);
        this.reporter = rt;
        this.myAgents = set;
    }

    public void postConstructor() {
        this.setupUI();
        this.setDefaultCloseOperation(2);
        final String myTitle = this.getTitle();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                View25DExtension.removeTurtleWindowWithTitle(myTitle);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        GLCapabilities glCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        GLCanvas glCanvas = new GLCanvas((GLCapabilitiesImmutable)glCapabilities);
        this.glManager = new TurtleGL(this);
        glCanvas.addGLEventListener((GLEventListener)this.glManager);
        glCanvas.addMouseListener((MouseListener)this.glManager);
        glCanvas.addMouseMotionListener((MouseMotionListener)this.glManager);
        glCanvas.addMouseWheelListener((MouseWheelListener)this.glManager);
        this.glManager.setCanvas(glCanvas);
        this.mainPanel.add((Component)glCanvas, "Center");
        this.viewOptions = new TurtleViewOptions(this, true, true, true, false, true, false);
        this.mainPanel.add((Component)this.viewOptions, "North");
        this.setSize(new Dimension(600, 640));
        this.xExpand = 0;
        this.yExpand = 40;
        this.centerWindow(this);
    }

    @Override
    public void manuallyRefreshReporterView(Context context) throws LogoException {
        this.updateArrayList(context);
        this.glManager.repaintCanvas();
    }

    public void updateTurtleShapes() {
        this.glManager.updateTurtleDisplayList();
        this.glManager.repaintCanvas();
    }

    private void updateArrayList(Context context) throws LogoException {
        ArrayList<TurtleValue> tempTurtles = new ArrayList<TurtleValue>();
        ArrayList<LinkValue> tempLinks = new ArrayList<LinkValue>();
        for (Agent a : this.myAgents.agents()) {
            Turtle turtle = (Turtle)a;
            if (turtle.hidden()) continue;
            java.awt.Color c = Color.getColor((Object)turtle.color());
            double val = (Double)this.reporter.report(context, new Object[]{turtle});
            double stemColor = this.getStemColor(context, turtle);
            TurtleValue tv = new TurtleValue(turtle.shape(), c, turtle.size(), turtle.xcor(), turtle.ycor(), val, stemColor);
            tempTurtles.add(tv);
        }
        Set<org.nlogo.api.Link> linkSet = TurtleView.getLinkSetFromTurtleSet(this.myAgents);
        for (org.nlogo.api.Link link : linkSet) {
            Turtle end1 = (Turtle)link.end1();
            Turtle end2 = (Turtle)link.end2();
            java.awt.Color c = Color.getColor((Object)link.color());
            double zcor1 = (Double)this.reporter.report(context, new Object[]{end1});
            double zcor2 = (Double)this.reporter.report(context, new Object[]{end2});
            LinkValue lv = new LinkValue(link.shape(), c, link.lineThickness(), end1.xcor(), end1.ycor(), zcor1, end2.xcor(), end2.ycor(), zcor2);
            tempLinks.add(lv);
        }
        this.turtleReporterValues = tempTurtles;
        this.linkValues = tempLinks;
        if (this.viewOptions.usePColor()) {
            this.updatePColors();
        }
    }

    public static Set<org.nlogo.api.Link> getLinkSetFromTurtleSet(AgentSet turtleSet) {
        HashSet<org.nlogo.api.Link> linkSet = new HashSet<org.nlogo.api.Link>();
        World world = App.app().workspace().world();
        if (world.links().count() == 0 || turtleSet.count() == 0) {
            return linkSet;
        }
        for (Agent a : turtleSet.agents()) {
            Turtle turtle = (Turtle)a;
            Link[] links = turtle.links();
            if (links.length == 0) continue;
            for (Link link : links) {
                if (link.hidden()) continue;
                linkSet.add((org.nlogo.api.Link)link);
            }
        }
        return linkSet;
    }

    private void updatePColors() {
        for (int i = 0; i < this.worldWidth; ++i) {
            for (int j = 0; j < this.worldHeight; ++j) {
                try {
                    Patch patch = App.app().workspace().world().getPatchAt((double)(i + this.minPxcor), (double)(j + this.minPycor));
                    this.patchColorMatrix[i][j] = Color.getColor((Object)patch.pcolor());
                    continue;
                }
                catch (AgentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayList<TurtleValue> getCopyOfReporterValues() {
        ArrayList<TurtleValue> rtn = new ArrayList<TurtleValue>(this.turtleReporterValues.size());
        rtn.addAll(this.turtleReporterValues);
        return rtn;
    }

    public ArrayList<LinkValue> getCopyOfLinkValues() {
        ArrayList<LinkValue> rtn = new ArrayList<LinkValue>(this.linkValues.size());
        rtn.addAll(this.linkValues);
        return rtn;
    }

    public void setupForRendering(int wWidth, int wHeight, int minX, int maxX, int minY, int maxY) {
        this.worldWidth = wWidth;
        this.worldHeight = wHeight;
        this.minPxcor = minX;
        this.minPycor = minY;
        this.maxPxcor = maxX;
        this.maxPycor = maxY;
        this.turtleReporterValues = new ArrayList(this.myAgents.count());
        this.patchColorMatrix = new java.awt.Color[this.worldWidth][this.worldHeight];
        for (int i = 0; i < this.worldWidth; ++i) {
            for (int j = 0; j < this.worldHeight; ++j) {
                this.patchColorMatrix[i][j] = java.awt.Color.BLUE;
            }
        }
    }

    public void setAgentSet(AgentSet as) {
        this.myAgents = as;
    }

    @Override
    public void resetPerspective() {
        this.glManager.observer.goHome(this);
        this.refresh();
    }

    public void refresh() {
        this.glManager.repaintCanvas();
        if (this.viewOptions.usePColor()) {
            this.updatePColors();
        }
    }

    @Override
    public void zoomZby(double change) {
        if (-change < this.zScale) {
            this.zScale += change;
        }
        this.glManager.repaintCanvas();
    }

    public double trimStemColor(double stemColor) {
        if (stemColor < 0.0) {
            stemColor = 0.0;
        }
        if (stemColor >= 140.0) {
            stemColor = 139.9;
        }
        return stemColor;
    }

    public double getStemColor(Context context, Turtle turtle) throws LogoException {
        double stemColor;
        if (this.stemColorReporter == null) {
            stemColor = this.defaultStemColor;
        } else {
            try {
                stemColor = (Double)this.stemColorReporter.report(context, new Object[]{turtle});
            }
            catch (Exception e1) {
                throw new LogoException("Stem color reporter did not generate a number. ", e1){};
            }
        }
        return this.trimStemColor(stemColor);
    }

    public AnonymousReporter getStemColorReporter() {
        return this.stemColorReporter;
    }

    public void setStemColorReporter(AnonymousReporter reporter) {
        this.stemColorReporter = reporter;
    }
}

