/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpGrid;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.projection.Projection;

public strictfp final class RasterUtils {
    public static RenderedImage reproject(BufferedImage image, GridDimensions srcDimensions, Projection srcProj, GridDimensions dstDimensions, Projection dstProj, GeometryFactory factory, Object missingPixel) {
        GeometryTransformer geogToSrc = srcProj.getForwardTransformer();
        GeometryTransformer dstToGeog = dstProj.getInverseTransformer();
        double yFudge = dstDimensions.getCellHeight() * 0.01;
        double xFudge = dstDimensions.getCellWidth() * 0.01;
        int xNumCells = dstDimensions.getGridWidth();
        int yNumCells = dstDimensions.getGridHeight();
        float[] warpPositions = new float[2 * (xNumCells + 1) * (yNumCells + 1)];
        int index = 0;
        for (int y = 0; y <= yNumCells; ++y) {
            double dstY = dstDimensions.getRowBottom(yNumCells - y);
            if (y == 0) {
                dstY += yFudge;
            } else if (y == yNumCells) {
                dstY -= yFudge;
            }
            for (int x = 0; x <= xNumCells; ++x) {
                double dstX = dstDimensions.getColumnLeft(x);
                if (x == 0) {
                    dstX += xFudge;
                } else if (x == xNumCells) {
                    dstX -= xFudge;
                }
                Point dest = factory.createPoint(new Coordinate(dstX, dstY));
                Point src = (Point)geogToSrc.transform(dstToGeog.transform((Geometry)dest));
                if (!src.isEmpty()) {
                    Coordinate c = srcDimensions.gisToGrid(src.getCoordinate(), null);
                    warpPositions[index++] = (float)c.x;
                    warpPositions[index++] = (float)((double)srcDimensions.getGridHeight() - c.y);
                    continue;
                }
                warpPositions[index++] = Float.NaN;
                warpPositions[index++] = Float.NaN;
            }
        }
        WarpGrid warp = new WarpGrid(0, 1, xNumCells, 0, 1, yNumCells, warpPositions);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(warp);
        pb.add(new InterpolationNearest());
        ImageLayout layout = new ImageLayout();
        layout.setMinX(0);
        layout.setMinY(0);
        layout.setWidth(dstDimensions.getGridWidth());
        layout.setHeight(dstDimensions.getGridHeight());
        RenderingHints rh = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp result = JAI.create((String)"warp", (ParameterBlock)pb, (RenderingHints)rh);
        if (missingPixel == null) {
            return result;
        }
        ColorModel srcCM = image.getColorModel();
        WritableRaster wr = srcCM.createCompatibleWritableRaster(result.getWidth(), result.getHeight());
        result.copyData(wr);
        int wpIndex = 0;
        for (int y = 0; y < yNumCells; ++y) {
            for (int x = 0; x < xNumCells; ++x) {
                if (Float.isNaN(warpPositions[wpIndex]) || Float.isNaN(warpPositions[wpIndex + 1])) {
                    wr.setDataElements(x, y, missingPixel);
                }
                wpIndex += 2;
            }
            wpIndex += 2;
        }
        return new BufferedImage(srcCM, wr, false, null);
    }
}

