/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.myworldgis.projection.AbstractProjection;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.projection.ProjectionUtils;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class Geographic
extends AbstractProjection {
    private Unit<Angle> _units;
    private UnitConverter _toRadians;
    private UnitConverter _fromRadians;
    private double _cosPhi0;

    public Geographic(Ellipsoid ellipsoid, Coordinate center, Unit<Angle> units) {
        super(ellipsoid, center);
        this._name = "Geographic";
        this._units = units;
        this._toRadians = this._units.getConverterTo(SI.RADIAN);
        this._fromRadians = SI.RADIAN.getConverterTo(this._units);
        this.computeParameters();
    }

    public Unit<Angle> getUnits() {
        return this._units;
    }

    public void setUnits(Unit<Angle> newUnits) {
        this._units = newUnits;
        this._toRadians = newUnits.getConverterTo(SI.RADIAN);
        this._fromRadians = SI.RADIAN.getConverterTo(newUnits);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Geographic proj = (Geographic)obj;
            return proj._units.equals(this._units);
        }
        return false;
    }

    public int hashCode() {
        return this._units.hashCode();
    }

    @Override
    public Point process(Point point) {
        return point;
    }

    @Override
    public MultiPolygon process(Polygon poly) {
        if (this._lineType == Projection.LineType.RHUMB) {
            poly = ProjectionUtils.createRhumbPoly(poly);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE) {
            poly = ProjectionUtils.createGreatCirclePoly(poly);
        }
        return ProjectionUtils.wrap(poly, this._lambda0);
    }

    @Override
    public MultiLineString process(LineString line) {
        if (this._lineType == Projection.LineType.RHUMB) {
            line = ProjectionUtils.createRhumbLine(line);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE) {
            line = ProjectionUtils.createGreatCircleLine(line);
        }
        return ProjectionUtils.wrap(line, this._lambda0);
    }

    @Override
    protected Coordinate forwardPoint(double lon, double lat, Coordinate storage) {
        storage.x = this._fromRadians.convert(GeometryUtils.wrap_longitude(lon - this._lambda0) * this._cosPhi0);
        storage.y = this._fromRadians.convert(lat);
        return storage;
    }

    @Override
    protected Coordinate inversePoint(double x, double y, Coordinate storage) {
        storage.x = this._lambda0 + this._toRadians.convert(x) / this._cosPhi0;
        storage.y = this._toRadians.convert(y);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._cosPhi0 = StrictMath.cos(this._phi0);
    }

    @Override
    public ProjectionParameters getParameters() {
        return new ProjectionParameters(this._units, (Unit<Length>)SI.METRE);
    }
}

