/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.myworldgis.netlogo.Dataset;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorFeature;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp final class VectorDataset
extends Dataset {
    private ShapeType _shapeType;
    private Envelope _envelope;
    private ArrayList<VectorFeature> _features;
    private SpatialIndex _spatialIndex;
    private Property[] _properties;

    static VectorDataset getDataset(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (obj instanceof VectorDataset) {
            return (VectorDataset)obj;
        }
        throw new ExtensionException("not a VectorDataset: " + obj);
    }

    public VectorDataset(ShapeType shapeType, String[] propertyNames, PropertyType[] propertyTypes) {
        super("VECTOR");
        this._shapeType = shapeType;
        this._features = new ArrayList();
        this._properties = new Property[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this._properties[i] = new Property(propertyNames[i], propertyTypes[i]);
        }
        this.reindex();
        GISExtension.getState().datasetLoadNotify();
    }

    public ShapeType getShapeType() {
        return this._shapeType;
    }

    public Collection<VectorFeature> getFeatures() {
        return Collections.unmodifiableCollection(this._features);
    }

    public Property[] getProperties() {
        Property[] result = new Property[this._properties.length];
        System.arraycopy(this._properties, 0, result, 0, this._properties.length);
        return result;
    }

    public boolean isValidPropertyName(String name) {
        for (int i = 0; i < this._properties.length; ++i) {
            if (!this._properties[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<VectorFeature> intersectingFeatures(Geometry geom) {
        final PreparedGeometry pGeom = PreparedGeometryFactory.prepare((Geometry)geom);
        final ArrayList<VectorFeature> result = new ArrayList<VectorFeature>();
        this._spatialIndex.query(geom.getEnvelopeInternal(), new ItemVisitor(){

            public void visitItem(Object item) {
                VectorFeature feature = (VectorFeature)item;
                if (pGeom.intersects(feature.getGeometry())) {
                    result.add(feature);
                }
            }
        });
        return result;
    }

    void add(Geometry geometry, Object[] propertyValues) {
        VectorFeature feature = new VectorFeature(this._shapeType, geometry, this._properties, propertyValues);
        Envelope featureEnvelope = feature.getEnvelope();
        this._envelope.expandToInclude(featureEnvelope);
        this._features.add(feature);
        this._spatialIndex.insert(featureEnvelope, (Object)feature);
    }

    private void reindex() {
        this._envelope = new Envelope();
        this._spatialIndex = new STRtree();
        for (int i = 0; i < this._features.size(); ++i) {
            VectorFeature feature = this._features.get(i);
            Envelope featureEnvelope = feature.getEnvelope();
            this._envelope.expandToInclude(featureEnvelope);
            this._spatialIndex.insert(featureEnvelope, (Object)feature);
        }
    }

    @Override
    public Envelope getEnvelope() {
        return new Envelope(this._envelope);
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        return "";
    }

    public String getNLTypeName() {
        return "VectorDataset";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorDataset) {
            VectorDataset vd = (VectorDataset)obj;
            return vd == this;
        }
        return false;
    }

    public strictfp static final class Property {
        private final String _name;
        private final PropertyType _type;

        public Property(String name, PropertyType type) {
            this._name = name.toUpperCase();
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public PropertyType getType() {
            return this._type;
        }
    }

    public strictfp static enum PropertyType {
        STRING,
        NUMBER;

    }

    public strictfp static enum ShapeType {
        POINT,
        LINE,
        POLYGON;

    }

    public strictfp static final class GetPropertyNames
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Property[] properties = VectorDataset.getDataset(args[0]).getProperties();
            LogoListBuilder result = new LogoListBuilder();
            for (int i = 0; i < properties.length; ++i) {
                result.add((Object)properties[i].getName());
            }
            return result.toLogoList();
        }
    }

    public strictfp static final class GetFeatures
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return LogoList.fromJava(VectorDataset.getDataset(args[0]).getFeatures());
            }
            catch (ExtensionException e) {
                throw e;
            }
            catch (Throwable t) {
                ExtensionException e = new ExtensionException("error parsing envelope");
                e.initCause(t);
                throw e;
            }
        }
    }
}

