/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.myworldgis.io.shapefile.ESRIShapeBuffer;
import org.myworldgis.io.shapefile.ESRIShapeConstants;
import org.myworldgis.io.shapefile.ESRIShapeIndexRecord;
import org.myworldgis.util.Buffer;
import org.ngs.ngunits.UnitConverter;

public strictfp final class ESRIShapeIndexWriter
implements ESRIShapeConstants {
    private RandomAccessFile _raf;
    private ESRIShapeBuffer _buffer;
    private Envelope _envelope;
    private int _esriShapeType;
    private int _fileSizeBytes;

    public ESRIShapeIndexWriter(RandomAccessFile file, Envelope envelope, int esriShapeType, UnitConverter radiansToFile, GeometryFactory factory) throws IOException {
        this._raf = file;
        this._envelope = envelope;
        this._esriShapeType = esriShapeType;
        this._buffer = new ESRIShapeBuffer(50000, radiansToFile, factory);
        this._fileSizeBytes = 100;
        this._buffer.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        this.writeHeader();
        this._raf.seek(100L);
    }

    private void writeHeader() throws IOException {
        this._buffer.clear(0, 100);
        this._buffer.putInt(0, 9994);
        this._buffer.putInt(24, this._fileSizeBytes / 2);
        this._buffer.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        this._buffer.putInt(28, 1000);
        this._buffer.putInt(32, this._esriShapeType);
        this._buffer.putBoundingBox(36, this._envelope);
        this._buffer.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        this._buffer.write(this._raf, 0, 100);
    }

    public void writeIndexRecord(ESRIShapeIndexRecord record) throws IOException {
        this._buffer.putInt(0, record.getOffsetBytes() / 2);
        this._buffer.putInt(4, record.getSizeBytes() / 2);
        this._buffer.write(this._raf, 0, 8);
        this._fileSizeBytes += 8;
    }

    public void close() throws IOException {
        this._raf.seek(0L);
        this.writeHeader();
        this._raf.setLength(this._fileSizeBytes);
        this._raf.close();
    }
}

