/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution.metrics;

import java.util.Random;
import org.openimaj.math.statistics.distribution.MultivariateDistribution;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.comparator.DistanceComparator;

public class SampledMultivariateDistanceComparator
implements DistanceComparator<MultivariateDistribution> {
    private static final int DEFAULT_SAMPLE = 1000;
    private int samples;
    private Random rng;

    public SampledMultivariateDistanceComparator() {
        this.samples = 1000;
        this.rng = new Random();
    }

    public SampledMultivariateDistanceComparator(int nsamples) {
        this();
        this.samples = nsamples;
    }

    public SampledMultivariateDistanceComparator(long seed, int nsamples) {
        this.rng = new Random(seed);
        this.samples = nsamples;
    }

    public double compare(MultivariateDistribution o1, MultivariateDistribution o2) {
        double[][] X = o1.sample(this.samples, this.rng);
        double[] sampleP = o2.estimateLogProbability(X);
        return ArrayUtils.sumValues((double[])sampleP);
    }

    public boolean isDistance() {
        return false;
    }
}

