/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution.kernel;

import java.util.Random;
import org.openimaj.math.statistics.distribution.kernel.UnivariateKernel;

public enum StandardUnivariateKernels implements UnivariateKernel
{
    Gaussian{

        @Override
        public double sample(Random rng) {
            return rng.nextGaussian();
        }

        @Override
        public double getCutOff() {
            return 3.0;
        }

        @Override
        public double evaluate(double value) {
            return Math.exp(-(value * value) / 2.0) / Math.sqrt(Math.PI * 2);
        }
    }
    ,
    Flat{

        @Override
        public double sample(Random rng) {
            return rng.nextGaussian() - 0.5;
        }

        @Override
        public double getCutOff() {
            return 0.5;
        }

        @Override
        public double evaluate(double value) {
            if (value > 0.5) {
                return 0.0;
            }
            if (value < -0.5) {
                return 0.0;
            }
            return 1.0;
        }
    };

}

