/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics;

import Jama.Matrix;

public class MeanAndCovariance {
    public final Matrix mean;
    public final Matrix covar;

    public MeanAndCovariance(float[][] samples) {
        int i;
        int nsamples = samples.length;
        int ndims = samples[0].length;
        this.mean = new Matrix(1, ndims);
        this.covar = new Matrix(ndims, ndims);
        for (int j = 0; j < nsamples; ++j) {
            for (int i2 = 0; i2 < ndims; ++i2) {
                this.mean.set(0, i2, this.mean.get(0, i2) + (double)samples[j][i2]);
            }
        }
        for (i = 0; i < ndims; ++i) {
            this.mean.set(0, i, this.mean.get(0, i) / (double)nsamples);
        }
        for (i = 0; i < ndims; ++i) {
            for (int j = 0; j < ndims; ++j) {
                double qij = 0.0;
                for (int k = 0; k < nsamples; ++k) {
                    qij += ((double)samples[k][i] - this.mean.get(0, i)) * ((double)samples[k][j] - this.mean.get(0, j));
                }
                this.covar.set(i, j, qij / (double)(nsamples - 1));
            }
        }
    }

    public MeanAndCovariance(double[][] samples) {
        int i;
        int nsamples = samples.length;
        int ndims = samples[0].length;
        this.mean = new Matrix(1, ndims);
        this.covar = new Matrix(ndims, ndims);
        for (int j = 0; j < nsamples; ++j) {
            for (int i2 = 0; i2 < ndims; ++i2) {
                this.mean.set(0, i2, this.mean.get(0, i2) + samples[j][i2]);
            }
        }
        for (i = 0; i < ndims; ++i) {
            this.mean.set(0, i, this.mean.get(0, i) / (double)nsamples);
        }
        for (i = 0; i < ndims; ++i) {
            for (int j = 0; j < ndims; ++j) {
                double qij = 0.0;
                for (int k = 0; k < nsamples; ++k) {
                    qij += (samples[k][i] - this.mean.get(0, i)) * (samples[k][j] - this.mean.get(0, j));
                }
                this.covar.set(i, j, qij / (double)(nsamples - 1));
            }
        }
    }

    public MeanAndCovariance(Matrix samples) {
        this(samples.getArray());
    }

    public Matrix getMean() {
        return this.mean;
    }

    public Matrix getCovariance() {
        return this.covar;
    }

    public static Matrix computeMean(float[][] samples) {
        return new MeanAndCovariance((float[][])samples).mean;
    }

    public static Matrix computeCovariance(float[][] samples) {
        return new MeanAndCovariance((float[][])samples).covar;
    }

    public static Matrix computeMean(double[][] samples) {
        return new MeanAndCovariance((double[][])samples).mean;
    }

    public static Matrix computeCovariance(double[][] samples) {
        return new MeanAndCovariance((double[][])samples).covar;
    }

    public static Matrix computeMean(Matrix samples) {
        return new MeanAndCovariance((Matrix)samples).mean;
    }

    public static Matrix computeCovariance(Matrix samples) {
        return new MeanAndCovariance((Matrix)samples).covar;
    }
}

