/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.whitening;

import Jama.Matrix;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.matrix.algorithm.pca.SvdPrincipalComponentAnalysis;
import org.openimaj.math.matrix.algorithm.whitening.PCAWhitening;
import org.openimaj.math.statistics.normalisation.Normaliser;

@Reference(type=ReferenceType.Article, author={"Anthony J. Bell", "Terrence J. Sejnowski"}, title="The `Independent Components' of Natural Scenes are Edge Filters.", year="1997", journal="VISION RESEARCH", pages={"3327", "", "3338"}, volume="37")
public class ZCAWhitening
extends PCAWhitening {
    public ZCAWhitening(double eps, Normaliser ns) {
        super(eps, ns);
    }

    @Override
    public void train(double[][] data) {
        this.ns.normalise(data);
        double[][] normData = this.ns.normalise(data);
        SvdPrincipalComponentAnalysis pca = new SvdPrincipalComponentAnalysis();
        pca.learnBasisNorm(new Matrix(normData));
        this.transform = pca.getBasis().copy();
        double[] weight = pca.getEigenValues();
        double[][] td = this.transform.getArray();
        for (int c = 0; c < weight.length; ++c) {
            weight[c] = 1.0 / Math.sqrt(weight[c] + this.eps);
        }
        for (int r = 0; r < td.length; ++r) {
            for (int c = 0; c < td[0].length; ++c) {
                td[r][c] = td[r][c] * weight[c];
            }
        }
        this.transform = this.transform.times(pca.getBasis().transpose());
    }
}

