/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

public class MeanVector {
    private double[] mean;
    private int n;

    public MeanVector() {
        this.reset();
    }

    public double[] update(double[] data) {
        return this.update(data, true);
    }

    public double[] update(double[] data, boolean copy) {
        if (copy) {
            data = (double[])data.clone();
        }
        if (this.mean == null) {
            this.mean = data;
            this.n = 1;
            return this.mean;
        }
        if (data.length != this.mean.length) {
            throw new RuntimeException("Cannot update mean");
        }
        for (int i = 0; i < data.length; ++i) {
            this.mean[i] = this.mean[i] + (data[i] - this.mean[i]) / (double)(this.n + 1);
        }
        ++this.n;
        return this.mean;
    }

    public double[] vec() {
        return this.mean;
    }

    public void reset() {
        this.mean = null;
        this.n = 0;
    }
}

