/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import java.util.Random;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.openimaj.util.function.Function;

public class GramSchmidtProcess
implements Function<double[], Vector[]> {
    Random r = new Random();

    public GramSchmidtProcess() {
    }

    public GramSchmidtProcess(int seed) {
        this.r = new Random(seed);
    }

    private Vector project(Vector v, Vector u) {
        return u.copy().scale(v.dot(u) / u.dot(u));
    }

    public Vector[] apply(double[] in) {
        Vector[] vmat = new Vector[in.length];
        vmat[0] = new DenseVector(in);
        double norm = vmat[0].norm(Vector.Norm.Two);
        vmat[0].scale(1.0 / norm);
        for (int j = 1; j < in.length; ++j) {
            Vector randvec = this.randvec(vmat[0].size(), norm);
            vmat[j] = new DenseVector(vmat[0]).add(randvec);
            for (int i = 0; i < j; ++i) {
                vmat[j].add(-1.0, this.project(vmat[j], vmat[i]));
            }
            vmat[j].scale(1.0 / vmat[j].norm(Vector.Norm.Two));
        }
        return vmat;
    }

    private Vector randvec(int nvec, double d) {
        double[] ret = new double[nvec];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = d * this.r.nextDouble();
        }
        return new DenseVector(ret);
    }

    public static void main(String[] args) {
        Vector[] allvec;
        GramSchmidtProcess proc = new GramSchmidtProcess();
        for (Vector vector : allvec = proc.apply(new double[]{0.0, 0.0, 1.0})) {
            System.out.println(vector);
        }
    }

    public static Vector[] perform(double[] dir) {
        return new GramSchmidtProcess(0).apply(dir);
    }
}

