/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.triangulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.math.geometry.shape.Triangle;

public class DelaunayTriangulator {
    static final float EPSILON = 1.0E-8f;

    private static boolean circumCircle(Point2d p, Triangle t, Circle circle) {
        if (Math.abs(t.firstVertex().getY() - t.secondVertex().getY()) < 1.0E-8f && Math.abs(t.secondVertex().getY() - t.thirdVertex().getY()) < 1.0E-8f) {
            System.err.println("CircumCircle: Points are coincident.");
            return false;
        }
        if (Math.abs(t.secondVertex().getY() - t.firstVertex().getY()) < 1.0E-8f) {
            float m2 = -(t.thirdVertex().getX() - t.secondVertex().getX()) / (t.thirdVertex().getY() - t.secondVertex().getY());
            float mx2 = (t.secondVertex().getX() + t.thirdVertex().getX()) / 2.0f;
            float my2 = (t.secondVertex().getY() + t.thirdVertex().getY()) / 2.0f;
            circle.setX((t.secondVertex().getX() + t.firstVertex().getX()) / 2.0f);
            circle.setY(m2 * (circle.getX() - mx2) + my2);
        } else if (Math.abs(t.thirdVertex().getY() - t.secondVertex().getY()) < 1.0E-8f) {
            float m1 = -(t.secondVertex().getX() - t.firstVertex().getX()) / (t.secondVertex().getY() - t.firstVertex().getY());
            float mx1 = (t.firstVertex().getX() + t.secondVertex().getX()) / 2.0f;
            float my1 = (t.firstVertex().getY() + t.secondVertex().getY()) / 2.0f;
            circle.setX((t.thirdVertex().getX() + t.secondVertex().getX()) / 2.0f);
            circle.setY(m1 * (circle.getX() - mx1) + my1);
        } else {
            float m1 = -(t.secondVertex().getX() - t.firstVertex().getX()) / (t.secondVertex().getY() - t.firstVertex().getY());
            float m2 = -(t.thirdVertex().getX() - t.secondVertex().getX()) / (t.thirdVertex().getY() - t.secondVertex().getY());
            float mx1 = (t.firstVertex().getX() + t.secondVertex().getX()) / 2.0f;
            float mx2 = (t.secondVertex().getX() + t.thirdVertex().getX()) / 2.0f;
            float my1 = (t.firstVertex().getY() + t.secondVertex().getY()) / 2.0f;
            float my2 = (t.secondVertex().getY() + t.thirdVertex().getY()) / 2.0f;
            circle.setX((m1 * mx1 - m2 * mx2 + my2 - my1) / (m1 - m2));
            circle.setY(m1 * (circle.getX() - mx1) + my1);
        }
        float dx = t.secondVertex().getX() - circle.getX();
        float dy = t.secondVertex().getY() - circle.getY();
        float rsqr = dx * dx + dy * dy;
        circle.setRadius((float)Math.sqrt(rsqr));
        dx = p.getX() - circle.getX();
        dy = p.getY() - circle.getY();
        float drsqr = dx * dx + dy * dy;
        return drsqr <= rsqr;
    }

    public static List<Triangle> triangulate(List<? extends Point2d> pxyz) {
        Collections.sort(pxyz, new XComparator());
        float xmin = pxyz.get(0).getX();
        float ymin = pxyz.get(0).getY();
        float xmax = xmin;
        float ymax = ymin;
        for (Point2d point2d : pxyz) {
            if (point2d.getX() < xmin) {
                xmin = point2d.getX();
            }
            if (point2d.getX() > xmax) {
                xmax = point2d.getX();
            }
            if (point2d.getY() < ymin) {
                ymin = point2d.getY();
            }
            if (!(point2d.getY() > ymax)) continue;
            ymax = point2d.getY();
        }
        float dx = xmax - xmin;
        float f = ymax - ymin;
        float dmax = dx > f ? dx : f;
        float xmid = (xmax + xmin) / 2.0f;
        float ymid = (ymax + ymin) / 2.0f;
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        HashSet<Triangle> complete = new HashSet<Triangle>();
        Triangle superTriangle = new Triangle(new Point2dImpl(xmid - 2.0f * dmax, ymid - dmax), new Point2dImpl(xmid, ymid + 2.0f * dmax), new Point2dImpl(xmid + 2.0f * dmax, ymid - dmax));
        triangles.add(superTriangle);
        ArrayList<Line2d> edges = new ArrayList<Line2d>();
        for (Point2d point2d : pxyz) {
            int j;
            edges.clear();
            Circle circle = new Circle(0.0f, 0.0f, 0.0f);
            for (j = triangles.size() - 1; j >= 0; --j) {
                Triangle t = triangles.get(j);
                if (complete.contains(t)) continue;
                boolean inside = DelaunayTriangulator.circumCircle(point2d, t, circle);
                if (circle.getX() + circle.getRadius() < point2d.getX()) {
                    complete.add(t);
                }
                if (!inside) continue;
                edges.add(new Line2d(t.firstVertex(), t.secondVertex()));
                edges.add(new Line2d(t.secondVertex(), t.thirdVertex()));
                edges.add(new Line2d(t.thirdVertex(), t.firstVertex()));
                triangles.remove(j);
            }
            for (j = 0; j < edges.size() - 1; ++j) {
                Line2d e1 = (Line2d)edges.get(j);
                for (int k = j + 1; k < edges.size(); ++k) {
                    Line2d e2 = (Line2d)edges.get(k);
                    if (e1.begin == e2.end && e1.end == e2.begin) {
                        e1.begin = null;
                        e1.end = null;
                        e2.begin = null;
                        e2.end = null;
                    }
                    if (e1.begin != e2.begin || e1.end != e2.end) continue;
                    e1.begin = null;
                    e1.end = null;
                    e2.begin = null;
                    e2.end = null;
                }
            }
            for (j = 0; j < edges.size(); ++j) {
                Line2d e = (Line2d)edges.get(j);
                if (e.begin == null || e.end == null) continue;
                triangles.add(new Triangle(e.begin, e.end, point2d));
            }
        }
        for (int i = triangles.size() - 1; i >= 0; --i) {
            Triangle triangle = triangles.get(i);
            if (!triangle.sharesVertex(superTriangle)) continue;
            triangles.remove(i);
        }
        return triangles;
    }

    private static class XComparator
    implements Comparator<Point2d> {
        private XComparator() {
        }

        @Override
        public int compare(Point2d p1, Point2d p2) {
            if (p1.getX() < p2.getX()) {
                return -1;
            }
            if (p1.getX() > p2.getX()) {
                return 1;
            }
            return 0;
        }
    }
}

