/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.estimation;

import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.AffineTransformModel;
import org.openimaj.math.geometry.transforms.estimation.sampling.BucketingSampler2d;
import org.openimaj.math.geometry.transforms.residuals.AlgebraicResidual2d;
import org.openimaj.math.model.fit.LMedS;
import org.openimaj.math.model.fit.RANSAC;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.pair.IndependentPair;

public class RobustAffineTransformEstimator
implements RobustModelFitting<Point2d, Point2d, AffineTransformModel> {
    private RobustModelFitting<Point2d, Point2d, AffineTransformModel> robustFitter;

    public RobustAffineTransformEstimator(double outlierProportion) {
        this.robustFitter = new LMedS<Point2d, Point2d, AffineTransformModel>(new AffineTransformModel(), new AlgebraicResidual2d(), outlierProportion, true, new BucketingSampler2d());
    }

    public RobustAffineTransformEstimator(double threshold, int nIterations, RANSAC.StoppingCondition stoppingCondition) {
        this.robustFitter = new RANSAC<Point2d, Point2d, AffineTransformModel>(new AffineTransformModel(), new AlgebraicResidual2d(), threshold, nIterations, stoppingCondition, true, new BucketingSampler2d());
    }

    public RobustAffineTransformEstimator(double outlierProportion, Predicate<AffineTransformModel> modelCheck) {
        this.robustFitter = new LMedS<Point2d, Point2d, AffineTransformModel>(new AffineTransformModel(modelCheck), new AlgebraicResidual2d(), outlierProportion, true, new BucketingSampler2d());
    }

    public RobustAffineTransformEstimator(double threshold, int nIterations, RANSAC.StoppingCondition stoppingCondition, Predicate<AffineTransformModel> modelCheck) {
        this.robustFitter = new RANSAC<Point2d, Point2d, AffineTransformModel>(new AffineTransformModel(modelCheck), new AlgebraicResidual2d(), threshold, nIterations, stoppingCondition, true, new BucketingSampler2d());
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<Point2d, Point2d>> data) {
        if (!this.robustFitter.fitData(data)) {
            ((AffineTransformModel)this.robustFitter.getModel()).estimate(data);
            return false;
        }
        return true;
    }

    @Override
    public int numItemsToEstimate() {
        return this.robustFitter.numItemsToEstimate();
    }

    @Override
    public AffineTransformModel getModel() {
        return (AffineTransformModel)this.robustFitter.getModel();
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getInliers() {
        return this.robustFitter.getInliers();
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getOutliers() {
        return this.robustFitter.getOutliers();
    }
}

