/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.math.model.fit.residuals.AbstractResidualCalculator;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class FundamentalModel
implements EstimatableModel<Point2d, Point2d> {
    protected boolean normalise;
    protected Matrix fundamental;

    public FundamentalModel() {
        this(true);
    }

    public FundamentalModel(boolean norm) {
        this.normalise = norm;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Point2d, Point2d>> data) {
        if (this.normalise) {
            Pair<Matrix> norms = TransformUtilities.getNormalisations(data);
            List<? extends IndependentPair<Point2d, Point2d>> normData = TransformUtilities.normalise(data, norms);
            Matrix normFundamental = TransformUtilities.fundamentalMatrix8Pt(normData);
            this.fundamental = ((Matrix)norms.secondObject()).transpose().times(normFundamental).times((Matrix)norms.firstObject());
        } else {
            this.fundamental = TransformUtilities.fundamentalMatrix8Pt(data);
        }
        return true;
    }

    public void denormaliseFundamental(Pair<Matrix> norms) {
        this.fundamental = ((Matrix)norms.secondObject()).transpose().times(this.fundamental).times((Matrix)norms.firstObject());
    }

    @Override
    public Point2d predict(Point2d data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numItemsToEstimate() {
        return 8;
    }

    public FundamentalModel clone() {
        FundamentalModel model = new FundamentalModel(this.normalise);
        if (model.fundamental != null) {
            model.fundamental = this.fundamental.copy();
        }
        return model;
    }

    public void setF(Matrix optimised) {
        this.fundamental = optimised;
    }

    public Matrix getF() {
        return this.fundamental;
    }

    public static class SampsonGeometricResidual
    extends AbstractResidualCalculator<Point2d, Point2d, FundamentalModel> {
        @Override
        public double computeResidual(IndependentPair<Point2d, Point2d> data) {
            Matrix p1 = new Matrix(3, 1);
            Matrix p2 = new Matrix(3, 1);
            p1.set(0, 0, (double)((Point2d)data.firstObject()).getX());
            p1.set(1, 0, (double)((Point2d)data.firstObject()).getY());
            p1.set(2, 0, 1.0);
            p2.set(0, 0, (double)((Point2d)data.secondObject()).getX());
            p2.set(1, 0, (double)((Point2d)data.secondObject()).getY());
            p2.set(2, 0, 1.0);
            double p2tFp1 = p2.transpose().times(((FundamentalModel)this.model).fundamental).times(p1).get(0, 0);
            Matrix Fp1 = ((FundamentalModel)this.model).fundamental.times(p1);
            Matrix Ftp2 = ((FundamentalModel)this.model).fundamental.transpose().times(p2);
            double dist = p2tFp1 * p2tFp1 / (Fp1.get(0, 0) * Fp1.get(0, 0) + Fp1.get(1, 0) * Fp1.get(1, 0) + Ftp2.get(0, 0) * Ftp2.get(0, 0) + Ftp2.get(1, 0) * Ftp2.get(1, 0));
            return Math.abs(dist);
        }
    }

    public static class EpipolarResidual
    extends AbstractResidualCalculator<Point2d, Point2d, FundamentalModel> {
        @Override
        public double computeResidual(IndependentPair<Point2d, Point2d> data) {
            Matrix p1Mat = new Matrix(3, 1);
            Matrix p2Mat = new Matrix(3, 1);
            p1Mat.set(0, 0, (double)((Point2d)data.firstObject()).getX());
            p1Mat.set(1, 0, (double)((Point2d)data.firstObject()).getY());
            p1Mat.set(2, 0, 1.0);
            p2Mat.set(0, 0, (double)((Point2d)data.secondObject()).getX());
            p2Mat.set(1, 0, (double)((Point2d)data.secondObject()).getY());
            p2Mat.set(2, 0, 1.0);
            Matrix l1 = ((FundamentalModel)this.model).fundamental.times(p1Mat);
            double n1 = Math.sqrt(l1.get(0, 0) * l1.get(0, 0) + l1.get(1, 0) * l1.get(1, 0));
            double d1 = Math.abs((l1.get(0, 0) * p2Mat.get(0, 0) + l1.get(1, 0) * p2Mat.get(1, 0) + l1.get(2, 0) * p2Mat.get(2, 0)) / n1);
            Matrix l2 = ((FundamentalModel)this.model).fundamental.transpose().times(p2Mat);
            double n2 = Math.sqrt(l2.get(0, 0) * l2.get(0, 0) + l2.get(1, 0) * l2.get(1, 0));
            double d2 = Math.abs((l2.get(0, 0) * p1Mat.get(0, 0) + l2.get(1, 0) * p1Mat.get(1, 0) + l2.get(2, 0) * p1Mat.get(2, 0)) / n2);
            return d1 + d2;
        }
    }

    public static class Fundamental8PtResidual
    extends AbstractResidualCalculator<Point2d, Point2d, FundamentalModel> {
        @Override
        public double computeResidual(IndependentPair<Point2d, Point2d> data) {
            Matrix F = ((FundamentalModel)this.model).fundamental;
            Point2d p1 = (Point2d)data.firstObject();
            Point2d p2 = (Point2d)data.secondObject();
            float x1_1 = p1.getX();
            float x1_2 = p1.getY();
            float x2_1 = p2.getX();
            float x2_2 = p2.getY();
            double res = 0.0;
            res += F.get(0, 0) * (double)x2_1 * (double)x1_1;
            res += F.get(0, 1) * (double)x2_1 * (double)x1_2;
            res += F.get(0, 2) * (double)x2_1;
            res += F.get(1, 0) * (double)x2_2 * (double)x1_1;
            res += F.get(1, 1) * (double)x2_2 * (double)x1_2;
            res += F.get(1, 2) * (double)x2_2;
            res += F.get(2, 0) * (double)x1_1;
            res += F.get(2, 1) * (double)x1_2;
            return (res += F.get(2, 2)) * res;
        }
    }
}

