/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;

public class Triangle
implements Shape {
    public Point2d[] vertices;

    public Triangle(Point2d vertex1, Point2d vertex2, Point2d vertex3) {
        this.vertices = new Point2d[3];
        this.vertices[0] = vertex1;
        this.vertices[1] = vertex2;
        this.vertices[2] = vertex3;
    }

    public Triangle(Point2d[] vertices) {
        if (vertices.length != 3) {
            throw new IllegalArgumentException("Triangles must have three vertices");
        }
        this.vertices = vertices;
    }

    private final int getOrientation(float v1x, float v1y, float v2x, float v2y, float px, float py) {
        float ori = (v2x - v1x) * (py - v1y) - (px - v1x) * (v2y - v1y);
        if (ori == 0.0f) {
            return 0;
        }
        return ori < 0.0f ? -1 : 1;
    }

    public final boolean isInsideOnLine(Point2d point) {
        float v1x = this.vertices[0].getX();
        float v1y = this.vertices[0].getY();
        float v2x = this.vertices[1].getX();
        float v2y = this.vertices[1].getY();
        float v3x = this.vertices[2].getX();
        float v3y = this.vertices[2].getY();
        float px = point.getX();
        float py = point.getY();
        if (px > v1x && px > v2x && px > v3x) {
            return false;
        }
        if (px < v1x && px < v2x && px < v3x) {
            return false;
        }
        if (py > v1y && py > v2y && py > v3y) {
            return false;
        }
        if (py < v1y && py < v2y && py < v3y) {
            return false;
        }
        int o1 = this.getOrientation(v1x, v1y, v2x, v2y, px, py);
        int o2 = this.getOrientation(v2x, v2y, v3x, v3y, px, py);
        int o3 = this.getOrientation(v3x, v3y, v1x, v1y, px, py);
        return (o1 == 0 ? o2 : o1) == (o2 == 0 ? o1 : o2) && (o3 == 0 ? o2 : o3) == (o2 == 0 ? o1 : o2);
    }

    @Override
    public final boolean isInside(Point2d point) {
        float v1x = this.vertices[0].getX();
        float v1y = this.vertices[0].getY();
        float v2x = this.vertices[1].getX();
        float v2y = this.vertices[1].getY();
        float v3x = this.vertices[2].getX();
        float v3y = this.vertices[2].getY();
        float px = point.getX();
        float py = point.getY();
        if (px > v1x && px > v2x && px > v3x) {
            return false;
        }
        if (px < v1x && px < v2x && px < v3x) {
            return false;
        }
        if (py > v1y && py > v2y && py > v3y) {
            return false;
        }
        if (py < v1y && py < v2y && py < v3y) {
            return false;
        }
        int o1 = this.getOrientation(v1x, v1y, v2x, v2y, px, py);
        int o2 = this.getOrientation(v2x, v2y, v3x, v3y, px, py);
        int o3 = this.getOrientation(v3x, v3y, v1x, v1y, px, py);
        return o1 == o2 && o2 == o3;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        return new Rectangle((int)Math.round(this.minX()), (int)Math.round(this.minY()), (int)Math.round(this.getWidth()), (int)Math.round(this.getHeight()));
    }

    @Override
    public void translate(float x, float y) {
        for (Point2d v : this.vertices) {
            v.translate(x, y);
        }
    }

    @Override
    public void scale(float sc) {
        for (Point2d v : this.vertices) {
            v.setX(v.getX() * sc);
            v.setY(v.getY() * sc);
        }
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        Point2d centre = this.calculateCentroid();
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public Point2d calculateCentroid() {
        return new Point2dImpl((this.vertices[0].getX() + this.vertices[1].getX() + this.vertices[2].getX()) / 3.0f, (this.vertices[0].getY() + this.vertices[1].getY() + this.vertices[2].getY()) / 3.0f);
    }

    @Override
    public double calculateArea() {
        double xb = this.vertices[1].getX() - this.vertices[0].getX();
        double yb = this.vertices[1].getY() - this.vertices[0].getY();
        double xc = this.vertices[2].getX() - this.vertices[0].getX();
        double yc = this.vertices[2].getY() - this.vertices[0].getY();
        return 0.5 * Math.abs(xb * yc - xc * yb);
    }

    @Override
    public double minX() {
        return Math.min(this.vertices[0].getX(), Math.min(this.vertices[1].getX(), this.vertices[2].getX()));
    }

    @Override
    public double minY() {
        return Math.min(this.vertices[0].getY(), Math.min(this.vertices[1].getY(), this.vertices[2].getY()));
    }

    @Override
    public double maxX() {
        return Math.max(this.vertices[0].getX(), Math.max(this.vertices[1].getX(), this.vertices[2].getX()));
    }

    @Override
    public double maxY() {
        return Math.max(this.vertices[0].getY(), Math.max(this.vertices[1].getY(), this.vertices[2].getY()));
    }

    @Override
    public double getWidth() {
        return this.maxX() - this.minX();
    }

    @Override
    public double getHeight() {
        return this.maxY() - this.minY();
    }

    @Override
    public Triangle transform(Matrix transform) {
        Point2d[] newVertices = new Point2d[3];
        for (int i = 0; i < 3; ++i) {
            Matrix p1 = new Matrix(3, 1);
            p1.set(0, 0, (double)this.vertices[i].getX());
            p1.set(1, 0, (double)this.vertices[i].getY());
            p1.set(2, 0, 1.0);
            Matrix p2_est = transform.times(p1);
            Point2dImpl out = new Point2dImpl((float)(p2_est.get(0, 0) / p2_est.get(2, 0)), (float)(p2_est.get(1, 0) / p2_est.get(2, 0)));
            newVertices[i] = out;
        }
        return new Triangle(newVertices);
    }

    @Override
    public Polygon asPolygon() {
        Polygon polygon = new Polygon(this.vertices);
        return polygon;
    }

    public Point2d firstVertex() {
        return this.vertices[0];
    }

    public Point2d secondVertex() {
        return this.vertices[1];
    }

    public Point2d thirdVertex() {
        return this.vertices[2];
    }

    public List<Line2d> getEdges() {
        ArrayList<Line2d> edges = new ArrayList<Line2d>();
        edges.add(new Line2d(this.firstVertex(), this.secondVertex()));
        edges.add(new Line2d(this.secondVertex(), this.thirdVertex()));
        edges.add(new Line2d(this.thirdVertex(), this.firstVertex()));
        return edges;
    }

    public boolean sharesVertex(Triangle other) {
        for (Point2d v1 : this.vertices) {
            for (Point2d v2 : other.vertices) {
                if (v1 != v2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.intersectionArea(that, 1);
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimention) {
        Rectangle overlapping = this.calculateRegularBoundingBox().overlapping(that.calculateRegularBoundingBox());
        if (overlapping == null) {
            return 0.0;
        }
        double intersection = 0.0;
        double step = (double)Math.max(overlapping.width, overlapping.height) / (double)nStepsPerDimention;
        double nReads = 0.0;
        float x = overlapping.x;
        while (x < overlapping.x + overlapping.width) {
            float y = overlapping.y;
            while (y < overlapping.y + overlapping.height) {
                boolean insideThis = this.isInside(new Point2dImpl(x, y));
                boolean insideThat = that.isInside(new Point2dImpl(x, y));
                nReads += 1.0;
                if (insideThis && insideThat) {
                    intersection += 1.0;
                }
                y = (float)((double)y + step);
            }
            x = (float)((double)x + step);
        }
        return intersection / nReads * (double)(overlapping.width * overlapping.height);
    }

    @Override
    public Triangle clone() {
        Point2d[] newVertices = new Point2d[]{this.vertices[0].copy(), this.vertices[1].copy(), this.vertices[2].copy()};
        return new Triangle(newVertices);
    }

    public String toString() {
        return String.format("((%2.3f %2.3f), (%2.3f %2.3f), (%2.3f %2.3f))", Float.valueOf(this.vertices[0].getX()), Float.valueOf(this.vertices[0].getY()), Float.valueOf(this.vertices[1].getX()), Float.valueOf(this.vertices[1].getY()), Float.valueOf(this.vertices[2].getX()), Float.valueOf(this.vertices[2].getY()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.vertices);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triangle)) {
            return false;
        }
        Triangle tri = (Triangle)obj;
        for (int i = 0; i < 3; ++i) {
            if (tri.vertices[i].equals(this.vertices[i])) continue;
            return false;
        }
        return true;
    }

    public Map<Line2d, Point2d> intersectionSides(Line2d line) {
        HashMap<Line2d, Point2d> ret = new HashMap<Line2d, Point2d>();
        Line2d first = new Line2d(this.vertices[0], this.vertices[1]);
        Line2d second = new Line2d(this.vertices[1], this.vertices[2]);
        Line2d third = new Line2d(this.vertices[2], this.vertices[0]);
        this.addIntersect(ret, first, line);
        this.addIntersect(ret, second, line);
        this.addIntersect(ret, third, line);
        return ret;
    }

    private void addIntersect(Map<Line2d, Point2d> ret, Line2d line, Line2d otherline) {
        Line2d.IntersectionResult inter = line.getIntersection(otherline);
        switch (inter.type) {
            case INTERSECTING: {
                ret.put(line, inter.intersectionPoint);
                break;
            }
        }
    }

    @Override
    public double calculatePerimeter() {
        return Line2d.distance(this.vertices[0], this.vertices[1]) + Line2d.distance(this.vertices[1], this.vertices[2]) + Line2d.distance(this.vertices[2], this.vertices[0]);
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return this.asPolygon().minimumBoundingRectangle();
    }

    @Override
    public boolean isConvex() {
        return true;
    }
}

