/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.tinfour.voronoi.IBoundedVoronoiVertexSymbol;

public class BoundedVoronoiVertexSymbol
implements IBoundedVoronoiVertexSymbol {
    String label;
    Font font;
    Color color;

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void draw(Graphics g, double x, double y) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.color == null) {
            this.color = g2d.getColor();
        }
        if (this.font == null) {
            this.font = g2d.getFont();
        }
        Ellipse2D.Double e2d = new Ellipse2D.Double(x - 2.0, y - 2.0, 5.0, 5.0);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fill(e2d);
        g2d.draw(e2d);
        if (this.label != null && !this.label.isEmpty() && this.font != null) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout layout = new TextLayout(this.label, this.font, frc);
            Rectangle2D r2d = layout.getBounds();
            layout.draw(g2d, (float)(x + 3.0), (float)(y + 3.0 + r2d.getCenterY()));
        }
    }
}

