/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.standard;

import org.tinfour.common.INeighborEdgeLocator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.NeighborEdgeVertex;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdge;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.standard.StochasticLawsonsWalk;

class NeighborEdgeLocator
implements INeighborEdgeLocator {
    QuadEdge neighborEdge;
    final StochasticLawsonsWalk walker;
    final IncrementalTin tin;

    NeighborEdgeLocator(IncrementalTin tin) {
        this.tin = tin;
        this.walker = new StochasticLawsonsWalk(tin.getThresholds());
    }

    @Override
    public IQuadEdge getNeigborEdge(double x, double y) {
        QuadEdge e;
        if (!this.tin.isBootstrapped()) {
            return null;
        }
        if (this.neighborEdge == null) {
            this.neighborEdge = this.tin.getStartingEdge();
        }
        this.neighborEdge = e = this.walker.findAnEdgeFromEnclosingTriangle(this.neighborEdge, x, y);
        return e;
    }

    @Override
    public NeighborEdgeVertex getEdgeWithNearestVertex(double x, double y) {
        QuadEdge e;
        if (this.neighborEdge == null) {
            this.neighborEdge = this.tin.getStartingEdge();
        }
        this.neighborEdge = e = this.walker.findAnEdgeFromEnclosingTriangle(this.neighborEdge, x, y);
        Vertex a = e.getA();
        Vertex b = e.getB();
        Vertex c = e.getForward().getB();
        double dA = a.getDistanceSq(x, y);
        double dB = b.getDistanceSq(x, y);
        if (c == null) {
            if (dA < dB) {
                return new NeighborEdgeVertex(e, Math.sqrt(dA), x, y, false);
            }
            return new NeighborEdgeVertex(e.getForward(), Math.sqrt(dB), x, y, false);
        }
        double dC = c.getDistanceSq(x, y);
        if (dA < dB) {
            if (dA < dC) {
                return new NeighborEdgeVertex(e, Math.sqrt(dA), x, y, true);
            }
            return new NeighborEdgeVertex(e.getReverse(), Math.sqrt(dC), x, y, true);
        }
        if (dB < dC) {
            return new NeighborEdgeVertex(e.getForward(), Math.sqrt(dB), x, y, true);
        }
        return new NeighborEdgeVertex(e.getReverse(), Math.sqrt(dC), x, y, true);
    }

    @Override
    public void resetForChangeToTin() {
        this.neighborEdge = null;
    }
}

