/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.NearestEdgeResult;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualEdge;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.semivirtual.SemiVirtualStochasticLawsonsWalk;

class SemiVirtualIncrementalTinNavigator
implements IIncrementalTinNavigator {
    SemiVirtualEdge neighborEdge;
    final SemiVirtualStochasticLawsonsWalk walker;
    final SemiVirtualIncrementalTin tin;

    SemiVirtualIncrementalTinNavigator(SemiVirtualIncrementalTin tin) {
        this.tin = tin;
        this.walker = new SemiVirtualStochasticLawsonsWalk(tin.getThresholds());
    }

    @Override
    public IQuadEdge getNeighborEdge(double x, double y) {
        if (!this.tin.isBootstrapped()) {
            return null;
        }
        if (this.neighborEdge == null) {
            this.neighborEdge = this.tin.getStartingEdge();
        }
        this.neighborEdge = this.walker.findAnEdgeFromEnclosingTriangle(this.neighborEdge, x, y);
        return this.neighborEdge;
    }

    @Override
    public NearestEdgeResult getNearestEdge(double x, double y) {
        IQuadEdge a = this.getNeighborEdge(x, y);
        if (a == null) {
            return null;
        }
        IQuadEdge b = a.getForward();
        IQuadEdge c = a.getReverse();
        Vertex A = a.getA();
        Vertex B = b.getA();
        Vertex C = c.getA();
        double dX = x - A.getX();
        double dY = y - A.getY();
        double vX = B.getX() - A.getX();
        double vY = B.getY() - A.getY();
        double vM = Math.sqrt(vX * vX + vY * vY);
        double pX = -vY;
        double pY = vX;
        double pMin = (dX * pX + dY * pY) / vM;
        IQuadEdge e = a;
        if (C == null) {
            return new NearestEdgeResult(e, pMin, x, y, false);
        }
        vX = C.getX() - B.getX();
        vY = C.getY() - B.getY();
        pX = -vY;
        double test = (dX * pX + dY * (pY = vX)) / (vM = Math.sqrt(vX * vX + vY * vY));
        if (test < pMin) {
            pMin = test;
            e = b;
        }
        vX = A.getX() - C.getX();
        vY = A.getY() - C.getY();
        pX = -vY;
        pY = vX;
        vM = Math.sqrt(vX * vX + vY * vY);
        test = ((x - C.getX()) * pX + (y - C.getY()) * pY) / vM;
        if (test < pMin) {
            pMin = test;
            e = c;
        }
        return new NearestEdgeResult(e, pMin, x, y, true);
    }

    @Override
    public Vertex getNearestVertex(double x, double y) {
        NearestEdgeResult n = this.getNearestEdge(x, y);
        if (n == null) {
            return null;
        }
        return n.getNearestVertex();
    }

    @Override
    public SimpleTriangle getContainingTriangle(double x, double y) {
        IQuadEdge a = this.getNeighborEdge(x, y);
        if (a == null) {
            return null;
        }
        IQuadEdge b = a.getForward();
        IQuadEdge c = a.getReverse();
        return new SimpleTriangle(this.tin, a, b, c);
    }

    @Override
    public boolean isPointInsideTin(double x, double y) {
        IQuadEdge e = this.getNeighborEdge(x, y);
        if (e == null) {
            return false;
        }
        return e.getForward().getB() != null;
    }

    @Override
    public void resetForChangeToTin() {
        this.neighborEdge = null;
    }
}

