/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.Vertex;

public class VertexMergerGroup
extends Vertex {
    List<Vertex> list = new ArrayList<Vertex>();
    ResolutionRule rule = ResolutionRule.MeanValue;
    double zRule = this.z;

    public VertexMergerGroup(Vertex firstVertex) {
        super(firstVertex.x, firstVertex.y, firstVertex.z, firstVertex.getIndex());
        this.status = firstVertex.status;
        this.list.add(firstVertex);
    }

    public boolean addVertex(Vertex v) {
        if (v.isConstraintMember()) {
            this.setConstraintMember(true);
        }
        if (!v.isSynthetic()) {
            this.setSynthetic(false);
        }
        if (v instanceof VertexMergerGroup) {
            VertexMergerGroup g = (VertexMergerGroup)v;
            boolean added = false;
            for (Vertex a : g.list) {
                if (this.list.contains(a)) continue;
                this.list.add(a);
                added = true;
            }
            this.applyRule();
            return added;
        }
        if (this.list.contains(v)) {
            return false;
        }
        boolean added = this.list.add(v);
        this.applyRule();
        return added;
    }

    public boolean removeVertex(Vertex v) {
        boolean removed = this.list.remove(v);
        if (removed) {
            this.applyRule();
        }
        return removed;
    }

    private void applyRule() {
        switch (this.rule) {
            case MeanValue: {
                double zSum = 0.0;
                for (Vertex m : this.list) {
                    zSum += (double)m.z;
                }
                this.zRule = zSum / (double)this.list.size();
                break;
            }
            case MinValue: {
                double zMin = Double.POSITIVE_INFINITY;
                for (Vertex m : this.list) {
                    if (Double.isNaN(m.z)) {
                        zMin = Double.NaN;
                        break;
                    }
                    if (!((double)m.z < zMin)) continue;
                    zMin = m.z;
                }
                this.zRule = zMin;
                break;
            }
            case MaxValue: {
                double zMax = Double.NEGATIVE_INFINITY;
                for (Vertex m : this.list) {
                    if (Double.isNaN(m.z)) {
                        zMax = Double.NaN;
                        break;
                    }
                    if (!((double)m.z > zMax)) continue;
                    zMax = m.z;
                }
                this.zRule = zMax;
                break;
            }
        }
    }

    public void setResolutionRule(ResolutionRule rule) {
        if (rule == null || rule == this.rule) {
            return;
        }
        this.rule = rule;
        this.applyRule();
    }

    @Override
    public double getZ() {
        return this.zRule;
    }

    public Vertex[] getVertices() {
        return this.list.toArray(new Vertex[this.list.size()]);
    }

    public int getSize() {
        return this.list.size();
    }

    public boolean contains(Vertex v) {
        return this.list.contains(v);
    }

    @Override
    public void setAuxiliaryIndex(int auxiliaryIndex) {
        super.setAuxiliaryIndex(auxiliaryIndex);
        for (Vertex v : this.list) {
            v.setAuxiliaryIndex(auxiliaryIndex);
        }
    }

    public static enum ResolutionRule {
        MinValue,
        MeanValue,
        MaxValue;

    }
}

