/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.awt.geom.Rectangle2D;
import org.tinfour.common.Vertex;

public class Circumcircle {
    private double centerX;
    private double centerY;
    private double r2;
    private static final double MIN_TRIG_AREA = 1.0E-20;

    public double getRadiusSq() {
        return this.r2;
    }

    public double getRadius() {
        return Math.sqrt(this.r2);
    }

    public double getX() {
        return this.centerX;
    }

    public double getY() {
        return this.centerY;
    }

    public void copy(Circumcircle c) {
        this.centerX = c.centerX;
        this.centerY = c.centerY;
        this.r2 = c.r2;
    }

    public static Circumcircle computeCircumcircle(Vertex a, Vertex b, Vertex c) {
        Circumcircle circle = new Circumcircle();
        if (a == null || b == null || c == null) {
            circle.centerX = Double.POSITIVE_INFINITY;
            circle.centerY = Double.POSITIVE_INFINITY;
            circle.r2 = Double.POSITIVE_INFINITY;
            return circle;
        }
        circle.compute(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
        return circle;
    }

    public boolean compute(Vertex a, Vertex b, Vertex c) {
        if (a == null || b == null || c == null) {
            this.centerX = Double.POSITIVE_INFINITY;
            this.centerY = Double.POSITIVE_INFINITY;
            this.r2 = Double.POSITIVE_INFINITY;
            return false;
        }
        this.compute(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
        return Double.isFinite(this.r2);
    }

    public void compute(double x0, double y0, double x1, double y1, double x2, double y2) {
        double bx = x1 - x0;
        double cy = y2 - y0;
        double by = y1 - y0;
        double cx = x2 - x0;
        double d = 2.0 * (bx * cy - by * cx);
        if (Math.abs(d) < 1.0E-20) {
            this.centerX = Double.POSITIVE_INFINITY;
            this.centerY = Double.POSITIVE_INFINITY;
            this.r2 = Double.POSITIVE_INFINITY;
            return;
        }
        double b2 = bx * bx + by * by;
        double c2 = cx * cx + cy * cy;
        this.centerX = (cy * b2 - by * c2) / d;
        this.centerY = (bx * c2 - cx * b2) / d;
        this.r2 = this.centerX * this.centerX + this.centerY * this.centerY;
        this.centerX += x0;
        this.centerY += y0;
    }

    public void setCircumcenter(double x, double y, double r2) {
        this.centerX = x;
        this.centerY = y;
        this.r2 = r2;
    }

    public String toString() {
        return String.format("(%7.4f,%7.4f) r=%6.4f", this.centerX, this.centerY, Math.sqrt(this.r2));
    }

    public Rectangle2D getBounds() {
        double r = this.getRadius();
        return new Rectangle2D.Double(this.centerX - r, this.centerY - r, 2.0 * r, 2.0 * r);
    }
}

