/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.ValueAnimator;

public abstract class TimeBasedValueAnimator<T>
implements ValueAnimator<T> {
    private long startTime = 0L;
    private long animationLength = 0L;
    protected T startValue = null;
    protected T endValue = null;
    private double currentPC = 0.0;

    public TimeBasedValueAnimator(T initial, T end, long millis) {
        this.startValue = initial;
        this.endValue = end;
        this.animationLength = millis;
    }

    protected abstract T calculateValue(double var1);

    @Override
    public T nextValue() {
        long currentTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = currentTime;
        }
        this.currentPC = (double)(currentTime - this.startTime) / (double)this.animationLength;
        if (this.isComplete()) {
            return this.endValue;
        }
        return this.calculateValue(this.currentPC);
    }

    @Override
    public void reset() {
        this.startTime = 0L;
        this.currentPC = 0.0;
    }

    public boolean isComplete() {
        return this.currentPC >= 1.0;
    }

    @Override
    public boolean hasFinished() {
        return this.isComplete();
    }
}

