/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearShortValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearShortValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class ShortArrayValueAnimator
implements ValueAnimator<short[]> {
    ValueAnimator<Short>[] animators;

    @SafeVarargs
    public ShortArrayValueAnimator(ValueAnimator<Short> ... animators) {
        this.animators = animators;
    }

    public static ShortArrayValueAnimator makeLinear(int duration, short ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearShortValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new ShortArrayValueAnimator(animators);
    }

    public static ShortArrayValueAnimator makeLinear(int duration, int count, short start, short finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearShortValueAnimator(start, finish, duration);
        }
        return new ShortArrayValueAnimator(animators);
    }

    public static ShortArrayValueAnimator makeRandomLinear(int duration, short ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearShortValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new ShortArrayValueAnimator(animators);
    }

    public static ShortArrayValueAnimator makeRandomLinear(int duration, int count, short start, short finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearShortValueAnimator(start, finish, duration);
        }
        return new ShortArrayValueAnimator(animators);
    }

    @Override
    public short[] nextValue() {
        short[] value = new short[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Short> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Short> animator : this.animators) {
            animator.reset();
        }
    }
}

