/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.matrix;

import Jama.Matrix;
import java.util.Iterator;

public abstract class Operator {
    public Object reduce(Iterator<Object> elems) {
        if (!elems.hasNext()) {
            throw new IllegalArgumentException("At least one element is required.");
        }
        Object accumulator = elems.next();
        if (accumulator instanceof Matrix) {
            accumulator = ((Matrix)accumulator).copy();
        }
        return this.reduce(accumulator, elems);
    }

    public Object reduce(Object accumulator, Iterator<Object> elems) {
        while (elems.hasNext()) {
            accumulator = this.applyEquals(accumulator, elems.next());
        }
        return accumulator;
    }

    public Object apply(Object accumulator, Object elem) {
        if (accumulator instanceof Matrix) {
            return this.apply((Matrix)accumulator, elem);
        }
        if (accumulator instanceof Double) {
            return this.apply((double)((Double)accumulator), elem);
        }
        throw this.typeViolation(accumulator);
    }

    public Object applyEquals(Object accumulator, Object elem) {
        if (accumulator instanceof Matrix) {
            return this.applyEquals((Matrix)accumulator, elem);
        }
        if (accumulator instanceof Double) {
            return this.apply((double)((Double)accumulator), elem);
        }
        throw this.typeViolation(accumulator);
    }

    public Matrix apply(Matrix arg1, Object arg2) {
        return this.applyEquals(arg1.copy(), arg2);
    }

    public Matrix applyEquals(Matrix accumulator, Object elem) {
        if (elem instanceof Matrix) {
            return this.applyEquals(accumulator, (Matrix)elem);
        }
        if (elem instanceof Double) {
            return this.applyEquals(accumulator, (Double)elem);
        }
        throw this.typeViolation(elem);
    }

    public Object apply(double accumulator, Object elem) {
        if (elem instanceof Matrix) {
            return this.apply(accumulator, (Matrix)elem);
        }
        if (elem instanceof Double) {
            return this.apply(accumulator, (Double)elem);
        }
        throw this.typeViolation(elem);
    }

    public abstract double apply(double var1, double var3);

    protected IllegalArgumentException typeViolation(Object arg) {
        return new IllegalArgumentException("Inputs must be matrices or numbers, but got " + arg.getClass());
    }

    public Matrix applyEquals(Matrix accumulator, Matrix elem) {
        int numRows = accumulator.getRowDimension();
        int numCols = accumulator.getColumnDimension();
        int elemRows = elem.getRowDimension();
        int elemCols = elem.getColumnDimension();
        if (numRows != elemRows || numCols != elemCols) {
            throw new IllegalArgumentException("Matrices must have the same number of rows and columns. Needed a matrix with " + numRows + " rows and " + numCols + " columns, but found a matrix with " + elemRows + " rows and " + elemCols + " columns.");
        }
        double[][] accumulatorArray = accumulator.getArray();
        double[][] elemArray = elem.getArray();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                accumulatorArray[i][j] = this.apply(accumulatorArray[i][j], elemArray[i][j]);
            }
        }
        return accumulator;
    }

    public Matrix applyEquals(Matrix accumulator, double elem) {
        for (double[] row : accumulator.getArray()) {
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.apply(row[i], elem);
            }
        }
        return accumulator;
    }

    public Matrix apply(double accumulator, Matrix elem) {
        double[][] resultArray;
        for (double[] row : resultArray = elem.getArrayCopy()) {
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.apply(accumulator, row[i]);
            }
        }
        return new Matrix(resultArray);
    }
}

