/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics;

public final class DistUtils {
    public static final double pointToPointSqEucDist(double p1x, double p1y, double p2x, double p2y) {
        return (p2x -= p1x) * p2x + (p2y -= p1y) * p2y;
    }

    public static final double pointToPointEucDist(double p1x, double p1y, double p2x, double p2y) {
        return Math.hypot(p2x -= p1x, p2y -= p1y);
    }

    public static final double pointToPointMnhtDist(double p1x, double p1y, double p2x, double p2y) {
        p2x = Math.abs(p2x - p1x);
        p2y = Math.abs(p2y - p1y);
        return p2x + p2y;
    }

    public static final double pointToPointCbsvDist(double p1x, double p1y, double p2x, double p2y) {
        return (p2x = Math.abs(p2x - p1x)) > (p2y = Math.abs(p2y - p1y)) ? p2x : p2y;
    }

    public static final double pointToLineSqEucDist(double pointX, double pointY, double startX, double startY, double endX, double endY) {
        double sqSegLen;
        double toRet;
        double crossProd = (pointX -= startX) * (endY -= startY) - (pointY -= startY) * (endX -= startX);
        if (Double.isNaN(toRet = crossProd * crossProd / (sqSegLen = endX * endX + endY * endY))) {
            toRet = 0.0;
        } else if (Double.isInfinite(toRet)) {
            toRet = pointX * pointX + pointY * pointY;
        }
        return toRet;
    }

    public static final double pointToLineEucDist(double pointX, double pointY, double startX, double startY, double endX, double endY) {
        double sqDist = DistUtils.pointToLineSqEucDist(pointX, pointY, startX, startY, endX, endY);
        return Math.sqrt(sqDist);
    }

    public static final double pointToSegSqEucDist(double pointX, double pointY, double startX, double startY, double endX, double endY) {
        double dx = pointX - endX;
        double segDx = endX - startX;
        double dy = pointY - endY;
        double segDy = endY - startY;
        double dotProd = dx * segDx + dy * segDy;
        if (dotProd >= 0.0) {
            return dx * dx + dy * dy;
        }
        dx = pointX - startX;
        dy = pointY - startY;
        dotProd = dx * segDx + dy * segDy;
        if (dotProd <= 0.0) {
            return dx * dx + dy * dy;
        }
        double sqSqLen = segDx * segDx + segDy * segDy;
        double sqProjLen = dotProd * dotProd / sqSqLen;
        double toRet = dx * dx + dy * dy - sqProjLen;
        if (toRet < 0.0) {
            toRet = 0.0;
        }
        return toRet;
    }

    public static final double pointToSegEucDist(double pointX, double pointY, double startX, double startY, double endX, double endY) {
        return Math.sqrt(DistUtils.pointToSegSqEucDist(pointX, pointY, startX, startY, endX, endY));
    }
}

