/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.dense;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.AbstractBasicMatrix;
import org.la4j.matrix.dense.DenseMatrix;
import org.la4j.matrix.source.MatrixSource;
import org.la4j.vector.Vector;
import org.la4j.vector.dense.BasicVector;

public class Basic1DMatrix
extends AbstractBasicMatrix
implements DenseMatrix {
    private static final long serialVersionUID = 4071505L;
    private double[] self;

    public Basic1DMatrix() {
        this(0, 0);
    }

    public Basic1DMatrix(Matrix matrix) {
        this(Matrices.asUnsafeSource(matrix));
    }

    public Basic1DMatrix(MatrixSource source) {
        this(source.rows(), source.columns());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.self[i * this.columns + j] = source.get(i, j);
            }
        }
    }

    public Basic1DMatrix(double[][] array) {
        this(array.length, array[0].length);
        int offset = 0;
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(array[i], 0, this.self, offset, this.columns);
            offset += this.columns;
        }
    }

    public Basic1DMatrix(int rows, int columns) {
        this(rows, columns, new double[rows * columns]);
    }

    public Basic1DMatrix(int rows, int columns, double[] array) {
        super(Matrices.BASIC1D_FACTORY, rows, columns);
        this.self = array;
    }

    @Override
    public double get(int i, int j) {
        return this.self[i * this.columns + j];
    }

    @Override
    public void set(int i, int j, double value) {
        this.self[i * this.columns + j] = value;
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            for (int k = 0; k < this.columns; ++k) {
                double tmp = this.self[i * this.columns + k];
                this.self[i * this.columns + k] = this.self[j * this.columns + k];
                this.self[j * this.columns + k] = tmp;
            }
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i != j) {
            for (int k = 0; k < this.rows; ++k) {
                double tmp = this.self[k * this.columns + i];
                this.self[k * this.columns + i] = this.self[k * this.columns + j];
                this.self[k * this.columns + j] = tmp;
            }
        }
    }

    @Override
    public Vector getRow(int i) {
        double[] result = new double[this.columns];
        System.arraycopy(this.self, i * this.columns, result, 0, this.columns);
        return new BasicVector(result);
    }

    @Override
    public Matrix copy() {
        double[] $self = new double[this.rows * this.columns];
        System.arraycopy(this.self, 0, $self, 0, this.rows * this.columns);
        return new Basic1DMatrix(this.rows, this.columns, $self);
    }

    @Override
    public Matrix resize(int rows, int columns) {
        this.ensureDimensionsAreNotNegative(rows, columns);
        if (this.rows == rows && this.columns == columns) {
            return this.copy();
        }
        if (this.rows < rows && this.columns == columns) {
            double[] $self = new double[rows * columns];
            System.arraycopy(this.self, 0, $self, 0, this.rows * columns);
            return new Basic1DMatrix(rows, columns, $self);
        }
        double[] $self = new double[rows * columns];
        int columnSize = columns < this.columns ? columns : this.columns;
        int rowSize = rows < this.rows ? rows : this.rows;
        for (int i = 0; i < rowSize; ++i) {
            System.arraycopy(this.self, i * this.columns, $self, i * columns, columnSize);
        }
        return new Basic1DMatrix(rows, columns, $self);
    }

    @Override
    public double[][] toArray() {
        double[][] result = new double[this.rows][this.columns];
        int offset = 0;
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.self, offset, result[i], 0, this.columns);
            offset += this.columns;
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.columns);
        for (int i = 0; i < this.rows * this.columns; ++i) {
            out.writeDouble(this.self[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.self = new double[this.rows * this.columns];
        for (int i = 0; i < this.rows * this.columns; ++i) {
            this.self[i] = in.readDouble();
        }
    }
}

