/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ObjectDoublePair<Q> {
    public static final Comparator<ObjectDoublePair<?>> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<ObjectDoublePair<?>>(){

        @Override
        public int compare(ObjectDoublePair<?> o1, ObjectDoublePair<?> o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ObjectDoublePair<?>> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<ObjectDoublePair<?>>(){

        @Override
        public int compare(ObjectDoublePair<?> o1, ObjectDoublePair<?> o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public Q first;
    public double second;

    public ObjectDoublePair(Q f, double s) {
        this.first = f;
        this.second = s;
    }

    public ObjectDoublePair() {
    }

    public Q getFirst() {
        return this.first;
    }

    public void setFirst(Q first) {
        this.first = first;
    }

    public double getSecond() {
        return this.second;
    }

    public void setSecond(double second) {
        this.second = second;
    }

    public static <Q> ObjectDoublePair<Q> pair(Q q, double t) {
        return new ObjectDoublePair<Q>(q, t);
    }

    public static <Q> TDoubleArrayList getSecond(Iterable<ObjectDoublePair<Q>> data) {
        TDoubleArrayList extracted = new TDoubleArrayList();
        for (ObjectDoublePair<Q> item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static <Q> List<Q> getFirst(Iterable<ObjectDoublePair<Q>> data) {
        ArrayList<Q> extracted = new ArrayList<Q>();
        for (ObjectDoublePair<Q> item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }
}

