/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.list;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Scanner;
import org.openimaj.data.RandomData;
import org.openimaj.io.Readable;
import org.openimaj.util.list.RandomisableList;

public abstract class AbstractStreamBackedList<T extends Readable>
extends AbstractSequentialList<T>
implements RandomisableList<T> {
    private Object streamWrapper;
    protected final Class<T> clz;
    protected final int size;
    protected final boolean isBinary;
    protected final int headerLength;
    protected final int recordLength;
    protected int consumed = 0;
    private InputStream underlyingStream;

    protected AbstractStreamBackedList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, Class<T> clz) {
        this.size = size;
        this.isBinary = isBinary;
        this.headerLength = headerLength;
        this.recordLength = recordLength;
        this.clz = clz;
        if (isBinary) {
            this.streamWrapper = new DataInputStream(stream);
        } else {
            Scanner s = new Scanner(new InputStreamReader(stream));
            for (int i = 0; i < headerLength; ++i) {
                s.nextLine();
            }
            this.streamWrapper = s;
        }
        this.underlyingStream = stream;
    }

    protected AbstractStreamBackedList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, Class<T> clz, String charset) throws UnsupportedEncodingException {
        this.size = size;
        this.isBinary = isBinary;
        this.headerLength = headerLength;
        this.recordLength = recordLength;
        this.clz = clz;
        if (isBinary) {
            this.streamWrapper = new DataInputStream(stream);
        } else {
            Scanner s = new Scanner(new InputStreamReader(stream, charset));
            for (int i = 0; i < headerLength; ++i) {
                s.nextLine();
            }
            this.streamWrapper = s;
        }
        this.underlyingStream = stream;
    }

    protected T newElementInstance() {
        try {
            return (T)((Readable)this.clz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T readRecord(DataInput input) throws IOException {
        T element = this.newElementInstance();
        element.readBinary(input);
        return element;
    }

    protected T readRecordASCII(Scanner br) throws IOException {
        T element = this.newElementInstance();
        element.readASCII(br);
        return element;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.isBinary) {
            return new SLBinaryIterator();
        }
        return new SLAsciiIterator();
    }

    void close() {
        if (this.streamWrapper != null) {
            try {
                this.underlyingStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streamWrapper = null;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int consumed() {
        return this.consumed;
    }

    public int remaining() {
        return this.size - this.consumed;
    }

    @Override
    public RandomisableList<T> randomSubList(int nelem) {
        if (nelem > this.remaining()) {
            throw new IllegalArgumentException("not enough records remaining in list");
        }
        MemoryRandomisableList newList = new MemoryRandomisableList();
        int[] rnd = RandomData.getUniqueRandomInts(nelem, 0, this.remaining());
        Arrays.sort(rnd);
        for (int i : rnd) {
            newList.add(this.get(i));
        }
        Collections.shuffle(newList);
        return newList;
    }

    class MemoryRandomisableList
    extends ArrayList<T>
    implements RandomisableList<T> {
        private static final long serialVersionUID = 1L;

        MemoryRandomisableList() {
        }

        @Override
        public RandomisableList<T> randomSubList(int nelem) {
            if (nelem > AbstractStreamBackedList.this.remaining()) {
                throw new IllegalArgumentException("not enough elements in list");
            }
            int[] rnd = RandomData.getUniqueRandomInts(nelem, 0, this.size());
            MemoryRandomisableList newList = new MemoryRandomisableList();
            for (int i : rnd) {
                newList.add(this.get(i));
            }
            return newList;
        }
    }

    class SLAsciiIterator
    extends SLIterator {
        SLAsciiIterator() {
        }

        @Override
        public T next() {
            try {
                if (this.hasNext()) {
                    ++AbstractStreamBackedList.this.consumed;
                    return AbstractStreamBackedList.this.readRecordASCII((Scanner)AbstractStreamBackedList.this.streamWrapper);
                }
                return null;
            }
            catch (IOException e) {
                AbstractStreamBackedList.this.close();
                throw new RuntimeException(e);
            }
        }
    }

    class SLBinaryIterator
    extends SLIterator {
        SLBinaryIterator() {
        }

        @Override
        public T next() {
            try {
                if (this.hasNext()) {
                    ++AbstractStreamBackedList.this.consumed;
                    return AbstractStreamBackedList.this.readRecord((DataInputStream)AbstractStreamBackedList.this.streamWrapper);
                }
                return null;
            }
            catch (IOException e) {
                AbstractStreamBackedList.this.close();
                throw new RuntimeException(e);
            }
        }
    }

    abstract class SLIterator
    implements ListIterator<T> {
        SLIterator() {
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (AbstractStreamBackedList.this.streamWrapper == null) {
                return false;
            }
            boolean readMore = true;
            readMore &= AbstractStreamBackedList.this.size == -1;
            if (AbstractStreamBackedList.this.streamWrapper instanceof Scanner) {
                readMore &= ((Scanner)AbstractStreamBackedList.this.streamWrapper).hasNext();
            }
            boolean bl = readMore = readMore || AbstractStreamBackedList.this.consumed < AbstractStreamBackedList.this.size;
            if (readMore) {
                return true;
            }
            AbstractStreamBackedList.this.close();
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int nextIndex() {
            return Math.max(AbstractStreamBackedList.this.consumed + 1, AbstractStreamBackedList.this.size());
        }

        @Override
        public T previous() {
            return null;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

