/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseByteArray;

public class SparseBinSearchByteArray
extends SparseByteArray {
    protected int[] keys;
    protected byte[] values;
    protected int used;

    public SparseBinSearchByteArray(byte[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseBinSearchByteArray(int length, int used, int[] keys, byte[] values) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length < values.length) {
            throw new IllegalArgumentException("length is shorter than number of current values!");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys does not match number of values.");
        }
        this.length = length;
        this.used = used;
        this.keys = keys;
        this.values = values;
    }

    public SparseBinSearchByteArray(int length) {
        this(length, 10);
    }

    public SparseBinSearchByteArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.keys = new int[capacity];
        this.values = new byte[capacity];
    }

    public SparseBinSearchByteArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.keys = new int[capacity];
        this.values = new byte[capacity];
    }

    @Override
    public int[] indices() {
        return Arrays.copyOf(this.keys, this.used);
    }

    @Override
    public byte[] values() {
        return Arrays.copyOf(this.values, this.used);
    }

    @Override
    public Iterable<SparseByteArray.DualEntry> unionEntries(SparseByteArray otherArray) {
        if (otherArray instanceof SparseBinSearchByteArray) {
            return this.unionEntries((SparseBinSearchByteArray)otherArray);
        }
        return super.unionEntries(otherArray);
    }

    public Iterable<SparseByteArray.DualEntry> unionEntries(final SparseBinSearchByteArray otherArray) {
        return new Iterable<SparseByteArray.DualEntry>(){

            @Override
            public Iterator<SparseByteArray.DualEntry> iterator() {
                return new Iterator<SparseByteArray.DualEntry>(){
                    private SparseByteArray.DualEntry entry = new SparseByteArray.DualEntry();
                    private int innerIndex = 0;
                    private int otherInnerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchByteArray.this.used || this.otherInnerIndex < otherArray.used;
                    }

                    @Override
                    public SparseByteArray.DualEntry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.innerIndex < SparseBinSearchByteArray.this.used && (this.otherInnerIndex >= otherArray.used || SparseBinSearchByteArray.this.keys[this.innerIndex] < otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = SparseBinSearchByteArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchByteArray.this.values[this.innerIndex];
                            this.entry.otherValue = 0;
                            ++this.innerIndex;
                        } else if (this.otherInnerIndex < otherArray.used && (this.innerIndex >= SparseBinSearchByteArray.this.used || SparseBinSearchByteArray.this.keys[this.innerIndex] > otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = otherArray.keys[this.otherInnerIndex];
                            this.entry.value = 0;
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.otherInnerIndex;
                        } else {
                            this.entry.index = SparseBinSearchByteArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchByteArray.this.values[this.innerIndex];
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.innerIndex;
                            ++this.otherInnerIndex;
                        }
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SparseByteArray.Entry> entries() {
        return new Iterable<SparseByteArray.Entry>(){

            @Override
            public Iterator<SparseByteArray.Entry> iterator() {
                return new Iterator<SparseByteArray.Entry>(){
                    private SparseByteArray.Entry entry = new SparseByteArray.Entry();
                    private int innerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchByteArray.this.used;
                    }

                    @Override
                    public SparseByteArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.entry.index = SparseBinSearchByteArray.this.keys[this.innerIndex];
                        this.entry.value = SparseBinSearchByteArray.this.values[this.innerIndex];
                        ++this.innerIndex;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBinSearchByteArray)) {
            return false;
        }
        return this.length == ((SparseBinSearchByteArray)obj).length && this.used == ((SparseBinSearchByteArray)obj).used && Arrays.equals(this.keys, ((SparseBinSearchByteArray)obj).keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public byte get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? (byte)0 : this.values[spot];
    }

    public int hashCode() {
        return this.length ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public byte set(int key, byte value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public byte increment(int key, byte value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            byte by = (byte)(this.values[n] + value);
            this.values[n] = by;
            return by;
        }
        return this.update(-1 - spot, key, value);
    }

    private byte update(int spot, int key, byte value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    @Override
    public void compact() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public SparseByteArray copy() {
        SparseBinSearchByteArray copy = new SparseBinSearchByteArray(this.length);
        copy.used = this.used;
        copy.keys = Arrays.copyOf(this.keys, this.keys.length);
        copy.values = Arrays.copyOf(this.values, this.values.length);
        return copy;
    }

    @Override
    public SparseByteArray reverse() {
        int len = this.used;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            byte tmpVal = this.values[i];
            this.values[i] = this.values[len - i - 1];
            this.values[len - i - 1] = tmpVal;
            int tmpKey = this.keys[i];
            this.keys[i] = this.length - this.keys[len - i - 1];
            this.keys[len - i - 1] = this.length - tmpKey;
        }
        return this;
    }
}

