/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.util;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;

public class MemoryAudioSource
extends AudioStream {
    private AudioStream stream = null;
    private final List<SampleChunk> buffer = new ArrayList<SampleChunk>();
    private int currentIndex = -1;
    private long bufferLength = 0L;

    public MemoryAudioSource(AudioStream as) {
        this.stream = as;
    }

    @Override
    public SampleChunk nextSampleChunk() {
        if (!this.buffer.isEmpty() && this.currentIndex < this.buffer.size()) {
            return this.buffer.get(this.currentIndex++ - 1);
        }
        SampleChunk sc = this.stream.nextSampleChunk();
        if (sc != null) {
            this.buffer.add(sc);
            ++this.currentIndex;
            this.bufferLength += (long)((double)sc.getNumberOfSamples() / sc.getFormat().getSampleRateKHz());
            return sc;
        }
        return null;
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
    }

    @Override
    public long getLength() {
        if (this.stream.getLength() == -1L) {
            return this.bufferLength;
        }
        return this.stream.getLength();
    }
}

