/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure myConnection;
    private ConnectionFigure fPrototype;
    private Figure myTargetFigure;

    public ConnectionHandle(Figure figure, Locator locator, ConnectionFigure connectionFigure) {
        super(figure, locator);
        this.fPrototype = connectionFigure;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setConnection(this.createConnection());
        this.setUndoActivity(this.createUndoActivity(drawingView));
        Vector<ConnectionFigure> vector = new Vector<ConnectionFigure>();
        vector.add(this.getConnection());
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(vector));
        Point point = this.locate();
        this.getConnection().startPoint(point.x, point.y);
        this.getConnection().endPoint(point.x, point.y);
        drawingView.drawing().add(this.getConnection());
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector;
        Point point = new Point(n, n2);
        Figure figure = this.findConnectableFigure(n, n2, drawingView.drawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        if ((connector = this.findConnectionTarget(point.x, point.y, drawingView.drawing())) != null) {
            point = Geom.center(connector.displayBox());
        }
        this.getConnection().endPoint(point.x, point.y);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector = this.findConnectionTarget(n, n2, drawingView.drawing());
        if (connector != null) {
            this.getConnection().connectStart(this.startConnector());
            this.getConnection().connectEnd(connector);
            this.getConnection().updateConnection();
        } else {
            drawingView.drawing().remove(this.getConnection());
            this.setUndoActivity(null);
        }
        this.setConnection(null);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector startConnector() {
        Point point = this.locate();
        return this.owner().connectorAt(point.x, point.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        return new PasteCommand.UndoActivity(drawingView);
    }

    protected Connector findConnectionTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect() && !figure.includes(this.owner()) && this.getConnection().canConnect(this.owner(), figure)) {
            return this.findConnector(n, n2, figure);
        }
        return null;
    }

    private Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.blue);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.myConnection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected Figure getTargetFigure() {
        return this.myTargetFigure;
    }

    protected void setTargetFigure(Figure figure) {
        this.myTargetFigure = figure;
    }

    public Cursor getCursor() {
        return new AWTCursor(12);
    }
}

