/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.ClippingUpdateStrategy;
import org.jhotdraw.contrib.ComponentFigure;
import org.jhotdraw.contrib.CompositeFigureCreationTool;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.contrib.GraphicalCompositeFigure;
import org.jhotdraw.contrib.MDIDesktopPane;
import org.jhotdraw.contrib.MDI_DrawApplication;
import org.jhotdraw.contrib.PolygonTool;
import org.jhotdraw.contrib.SimpleLayouter;
import org.jhotdraw.contrib.SplitConnectionTool;
import org.jhotdraw.contrib.TextAreaFigure;
import org.jhotdraw.contrib.TextAreaTool;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.contrib.WindowMenu;
import org.jhotdraw.contrib.html.HTMLTextAreaFigure;
import org.jhotdraw.contrib.html.HTMLTextAreaTool;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.contrib.zoom.ZoomTool;
import org.jhotdraw.figures.BorderTool;
import org.jhotdraw.figures.ConnectedTextTool;
import org.jhotdraw.figures.ElbowConnection;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.InsertImageCommand;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.figures.ScribbleTool;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.samples.javadraw.Animator;
import org.jhotdraw.samples.javadraw.BouncingDrawing;
import org.jhotdraw.samples.javadraw.MySelectionTool;
import org.jhotdraw.samples.javadraw.URLTool;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.util.Animatable;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.UndoableCommand;
import org.jhotdraw.util.UndoableTool;

public class JavaDrawApp
extends MDI_DrawApplication {
    private Animator fAnimator;
    private static String fgSampleImagesPath = "/org/jhotdraw/samples/javadraw/sampleimages";
    private static String fgSampleImagesResourcePath = fgSampleImagesPath + "/";

    JavaDrawApp() {
        super("JHotDraw");
    }

    public JavaDrawApp(String string) {
        super(string);
    }

    protected DrawApplication createApplication() {
        return new JavaDrawApp();
    }

    protected DrawingView createDrawingView(Drawing drawing) {
        Dimension dimension = this.getDrawingViewSize();
        ZoomDrawingView zoomDrawingView = new ZoomDrawingView(this, dimension.width, dimension.height);
        zoomDrawingView.setDrawing(drawing);
        return zoomDrawingView;
    }

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JToolBar jToolBar) {
        super.createTools(jToolBar);
        Tool tool = new ZoomTool(this);
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ZOOM", "Zoom Tool", tool));
        tool = new UndoableTool(new TextTool(this, new TextFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TEXT", "Text Tool", tool));
        tool = new UndoableTool(new ConnectedTextTool(this, new TextFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this);
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/URL", "URL Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RectangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RECT", "Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RoundRectangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new EllipseFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new UndoableTool(new PolygonTool(this));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new TriangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new DiamondFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/DIAMOND", "Diamond Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new LineFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/LINE", "Line Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new LineConnection()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/CONN", "Connection Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new ElbowConnection()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new UndoableTool(new ScribbleTool(this));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new UndoableTool(new BorderTool(this));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/BORDDEC", "Border Tool", tool));
        JButton jButton = new JButton("Hello World");
        tool = new CreationTool(this, new ComponentFigure(jButton));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RECT", "Component Tool", tool));
        tool = new TextAreaTool(this, new TextAreaFigure());
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TEXTAREA", "TextArea Tool", tool));
        GraphicalCompositeFigure graphicalCompositeFigure = new GraphicalCompositeFigure();
        graphicalCompositeFigure.setLayouter(new SimpleLayouter(graphicalCompositeFigure));
        tool = new CreationTool(this, graphicalCompositeFigure);
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RECT", "Container Figure Tool", tool));
        tool = new CompositeFigureCreationTool(this, new RectangleFigure());
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RECT", "Nested Figure Tool", tool));
        tool = new HTMLTextAreaTool(this, new HTMLTextAreaFigure());
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TEXTAREA", "HTML TextArea Tool", tool));
        LineConnection lineConnection = new LineConnection();
        lineConnection.setStartDecoration(null);
        tool = new UndoableTool(new SplitConnectionTool(this, lineConnection));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Split Connection Tool", tool));
    }

    protected Tool createSelectionTool() {
        return new MySelectionTool(this);
    }

    protected void createMenus(JMenuBar jMenuBar) {
        super.createMenus(jMenuBar);
        this.addMenuIfPossible(jMenuBar, this.createAnimationMenu());
        this.addMenuIfPossible(jMenuBar, this.createImagesMenu());
        this.addMenuIfPossible(jMenuBar, this.createWindowMenu());
    }

    protected JMenu createAnimationMenu() {
        CommandMenu commandMenu = new CommandMenu("Animation");
        AbstractCommand abstractCommand = new AbstractCommand("Start Animation", this){

            public void execute() {
                JavaDrawApp.this.startAnimation();
            }
        };
        commandMenu.add(abstractCommand);
        abstractCommand = new AbstractCommand("Stop Animation", this){

            public void execute() {
                JavaDrawApp.this.endAnimation();
            }
        };
        commandMenu.add(abstractCommand);
        return commandMenu;
    }

    protected JMenu createWindowMenu() {
        CommandMenu commandMenu = new CommandMenu("Window");
        AbstractCommand abstractCommand = new AbstractCommand("New View", this){

            public void execute() {
                JavaDrawApp.this.newView();
            }
        };
        commandMenu.add(abstractCommand);
        abstractCommand = new AbstractCommand("New Window", this, false){

            public void execute() {
                JavaDrawApp.this.newWindow(JavaDrawApp.this.createDrawing());
            }
        };
        commandMenu.add(abstractCommand);
        commandMenu.addSeparator();
        commandMenu.add(new WindowMenu("Window List", (MDIDesktopPane)this.getDesktop(), this));
        return commandMenu;
    }

    protected JMenu createImagesMenu() {
        CommandMenu commandMenu = new CommandMenu("Images");
        URL uRL = this.getClass().getResource(fgSampleImagesPath);
        if (uRL == null) {
            throw new JHotDrawRuntimeException("Could not locate images: " + fgSampleImagesPath);
        }
        File file = new File(uRL.getFile());
        try {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = fgSampleImagesResourcePath + string;
                commandMenu.add(new UndoableCommand(new InsertImageCommand(string, string2, this)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commandMenu;
    }

    protected Drawing createDrawing() {
        BouncingDrawing bouncingDrawing = new BouncingDrawing();
        bouncingDrawing.setTitle(this.getDefaultDrawingTitle());
        return bouncingDrawing;
    }

    public void startAnimation() {
        if (this.view().drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.view().drawing()), this.view());
            this.fAnimator.start();
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
        }
    }

    protected JMenu createDebugMenu() {
        CommandMenu commandMenu = (CommandMenu)super.createDebugMenu();
        AbstractCommand abstractCommand = new AbstractCommand("Clipping Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new ClippingUpdateStrategy());
            }
        };
        commandMenu.add(abstractCommand);
        return commandMenu;
    }

    public static void main(String[] stringArray) {
        JavaDrawApp javaDrawApp = new JavaDrawApp();
        javaDrawApp.open();
    }
}

