/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.util.List;
import org.jhotdraw.figures.GroupFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class GroupCommand
extends AbstractCommand {
    public GroupCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        ((UndoActivity)this.getUndoActivity()).groupFigures();
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 1;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            List list = CollectionsFactory.current().createList();
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                this.getDrawingView().drawing().addAll(figure.figures());
                this.getDrawingView().addToSelectionAll(figure.figures());
                FigureEnumeration figureEnumeration2 = figure.figures();
                while (figureEnumeration2.hasNextFigure()) {
                    list.add(figureEnumeration2.nextFigure());
                }
            }
            this.setAffectedFigures(new FigureEnumerator(list));
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.groupFigures();
                return true;
            }
            return false;
        }

        public void groupFigures() {
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            this.getDrawingView().clearSelection();
            GroupFigure groupFigure = new GroupFigure();
            groupFigure.addAll(this.getAffectedFigures());
            Figure figure = this.getDrawingView().drawing().add(groupFigure);
            this.getDrawingView().addToSelection(figure);
            List list = CollectionsFactory.current().createList();
            list.add(figure);
            this.setAffectedFigures(new FigureEnumerator(list));
        }
    }
}

