/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.Helper;
import org.jhotdraw.contrib.MDIDesktopManager;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.NullDrawingView;

public class MDIDesktopPane
extends JDesktopPane
implements Desktop {
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager;
    private DrawApplication myDrawApplication;
    private DesktopEventService myDesktopEventService;
    private DrawingView selectedView;
    protected InternalFrameListener internalFrameListener = new InternalFrameAdapter(){

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            DrawingView drawingView = Helper.getDrawingView(internalFrameEvent.getInternalFrame());
            MDIDesktopPane.this.fireDrawingViewAddedEvent(drawingView);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            DrawingView drawingView = Helper.getDrawingView(internalFrameEvent.getInternalFrame());
            if (MDIDesktopPane.this.getComponentCount() == 0) {
                DrawingView drawingView2 = MDIDesktopPane.this.getActiveDrawingView();
                MDIDesktopPane.this.setActiveDrawingView(NullDrawingView.getManagedDrawingView(drawingView2.editor()));
                MDIDesktopPane.this.fireDrawingViewSelectedEvent(drawingView2, MDIDesktopPane.this.getActiveDrawingView());
            }
            MDIDesktopPane.this.fireDrawingViewRemovedEvent(drawingView);
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            DrawingView drawingView = Helper.getDrawingView(internalFrameEvent.getInternalFrame());
            DrawingView drawingView2 = MDIDesktopPane.this.getActiveDrawingView();
            MDIDesktopPane.this.setActiveDrawingView(drawingView);
            MDIDesktopPane.this.fireDrawingViewSelectedEvent(drawingView2, MDIDesktopPane.this.getActiveDrawingView());
        }
    };

    public MDIDesktopPane(DrawApplication drawApplication) {
        this.setDesktopEventService(this.createDesktopEventService());
        this.setDrawApplication(drawApplication);
        this.manager = new MDIDesktopManager(this);
        this.setDesktopManager(this.manager);
        this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        this.setAlignmentX(0.0f);
    }

    protected void fireDrawingViewAddedEvent(DrawingView drawingView) {
        this.getDesktopEventService().fireDrawingViewAddedEvent(drawingView);
    }

    protected void fireDrawingViewRemovedEvent(DrawingView drawingView) {
        this.getDesktopEventService().fireDrawingViewRemovedEvent(drawingView);
    }

    protected void fireDrawingViewSelectedEvent(DrawingView drawingView, DrawingView drawingView2) {
        this.getDesktopEventService().fireDrawingViewSelectedEvent(drawingView, drawingView2);
    }

    protected Component createContents(DrawingView drawingView) {
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)drawingView));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setAlignmentX(0.0f);
        String string = drawingView.drawing().getTitle() == null ? this.getDrawApplication().getApplicationName() + " - " + this.getDrawApplication().getDefaultDrawingTitle() : this.getDrawApplication().getApplicationName() + " - " + drawingView.drawing().getTitle();
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
        jInternalFrame.setName(string);
        jInternalFrame.getContentPane().add(jScrollPane);
        jInternalFrame.setSize(200, 200);
        return jInternalFrame;
    }

    public DrawingView getActiveDrawingView() {
        return this.selectedView;
    }

    protected void setActiveDrawingView(DrawingView drawingView) {
        this.selectedView = drawingView;
    }

    public void updateTitle(String string) {
        this.getSelectedFrame().setTitle(string);
    }

    public void addToDesktop(DrawingView drawingView, int n) {
        JInternalFrame jInternalFrame = (JInternalFrame)this.createContents(drawingView);
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        Point point = null;
        jInternalFrame.addInternalFrameListener(this.internalFrameListener);
        super.add(jInternalFrame);
        this.checkDesktopSize();
        if (jInternalFrameArray.length > 0) {
            point = jInternalFrameArray[0].getLocation();
            point.x += FRAME_OFFSET;
            point.y += FRAME_OFFSET;
        } else {
            point = new Point(0, 0);
        }
        jInternalFrame.setLocation(point.x, point.y);
        if (jInternalFrame.isResizable()) {
            int n2 = this.getWidth() - this.getWidth() / 3;
            int n3 = this.getHeight() - this.getHeight() / 3;
            if ((double)n2 < jInternalFrame.getMinimumSize().getWidth()) {
                n2 = (int)jInternalFrame.getMinimumSize().getWidth();
            }
            if ((double)n3 < jInternalFrame.getMinimumSize().getHeight()) {
                n3 = (int)jInternalFrame.getMinimumSize().getHeight();
            }
            jInternalFrame.setSize(n2, n3);
        }
        this.moveToFront(jInternalFrame);
        jInternalFrame.setVisible(true);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            jInternalFrame.toBack();
        }
    }

    public void removeFromDesktop(DrawingView drawingView, int n) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (drawingView != Helper.getDrawingView(componentArray[i])) continue;
            ((JInternalFrame)componentArray[i]).dispose();
            break;
        }
        this.checkDesktopSize();
    }

    public void removeAllFromDesktop(int n) {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            jInternalFrameArray[i].dispose();
        }
    }

    public DrawingView[] getAllFromDesktop(int n) {
        Component[] componentArray = this.getComponents();
        ArrayList<DrawingView> arrayList = new ArrayList<DrawingView>();
        for (int i = 0; i < componentArray.length; ++i) {
            DrawingView drawingView = Helper.getDrawingView(componentArray[i]);
            if (drawingView == null) continue;
            arrayList.add(drawingView);
        }
        DrawingView[] drawingViewArray = new DrawingView[arrayList.size()];
        arrayList.toArray(drawingViewArray);
        return drawingViewArray;
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService desktopEventService) {
        this.myDesktopEventService = desktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this);
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().addDesktopListener(desktopListener);
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().removeDesktopListener(desktopListener);
    }

    public void cascadeFrames() {
        int n = 0;
        int n2 = 0;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int n3 = this.getBounds().height - 5 - jInternalFrameArray.length * FRAME_OFFSET;
        int n4 = this.getBounds().width - 5 - jInternalFrameArray.length * FRAME_OFFSET;
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            try {
                jInternalFrameArray[i].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            jInternalFrameArray[i].setBounds(n, n2, n4, n3);
            n += FRAME_OFFSET;
            n2 += FRAME_OFFSET;
        }
        this.checkDesktopSize();
    }

    public void tileFrames() {
        this.tileFramesHorizontally();
    }

    public void tileFramesHorizontally() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int n = this.getBounds().height / jInternalFrameArray.length;
        int n2 = 0;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            try {
                jInternalFrameArray[i].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            jInternalFrameArray[i].setBounds(0, n2, this.getBounds().width, n);
            n2 += n;
        }
        this.checkDesktopSize();
    }

    public void tileFramesVertically() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int n = this.getBounds().width / jInternalFrameArray.length;
        int n2 = 0;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            try {
                jInternalFrameArray[i].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            jInternalFrameArray[i].setBounds(n2, 0, n, this.getBounds().height);
            n2 += n;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesVertically() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int n = (int)Math.floor(Math.sqrt(jInternalFrameArray.length));
        int n2 = (int)Math.ceil(Math.sqrt(jInternalFrameArray.length));
        int n3 = this.getBounds().width / n2;
        int n4 = this.getBounds().height / n;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            n6 = 0;
            for (int j = 0; j < n; ++j) {
                try {
                    jInternalFrameArray[n7].setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
                jInternalFrameArray[n7].setBounds(n5, n6, n3, n4);
                ++n7;
                n6 += n4;
            }
            n5 += n3;
        }
        n4 = this.getBounds().height / (jInternalFrameArray.length - n7);
        n6 = 0;
        while (n7 < jInternalFrameArray.length) {
            try {
                jInternalFrameArray[n7].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            jInternalFrameArray[n7].setBounds(n5, n6, n3, n4);
            n6 += n4;
            ++n7;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesHorizontally() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int n = (int)Math.ceil(Math.sqrt(jInternalFrameArray.length));
        int n2 = (int)Math.floor(Math.sqrt(jInternalFrameArray.length));
        int n3 = this.getBounds().width / n2;
        int n4 = this.getBounds().height / n;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n - 1; ++i) {
            n5 = 0;
            for (int j = 0; j < n2; ++j) {
                try {
                    jInternalFrameArray[n7].setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
                jInternalFrameArray[n7].setBounds(n5, n6, n3, n4);
                ++n7;
                n5 += n3;
            }
            n6 += n4;
        }
        n3 = this.getBounds().width / (jInternalFrameArray.length - n7);
        n5 = 0;
        while (n7 < jInternalFrameArray.length) {
            try {
                jInternalFrameArray[n7].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            jInternalFrameArray[n7].setBounds(n5, n6, n3, n4);
            n5 += n3;
            ++n7;
        }
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setBounds(0, 0, dimension.width, dimension.height);
    }

    public void setAllSize(int n, int n2) {
        this.setAllSize(new Dimension(n, n2));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    private void setDrawApplication(DrawApplication drawApplication) {
        this.myDrawApplication = drawApplication;
    }

    protected DrawApplication getDrawApplication() {
        return this.myDrawApplication;
    }
}

