/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.openimaj.image.ARGBPlane;
import org.openimaj.image.ExtendedImageIO;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.io.InputStreamObjectReader;

public class ImageUtilities {
    public static final InputStreamObjectReader<FImage> FIMAGE_READER = new InputStreamObjectReader<FImage>(){

        public FImage read(InputStream stream) throws IOException {
            return ImageUtilities.readF(stream);
        }

        public boolean canRead(InputStream stream, String name) {
            try {
                ByteSourceInputStream src = new ByteSourceInputStream(stream, name);
                return Sanselan.guessFormat((ByteSource)src) != ImageFormat.IMAGE_FORMAT_UNKNOWN;
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    public static final InputStreamObjectReader<MBFImage> MBFIMAGE_READER = new InputStreamObjectReader<MBFImage>(){

        public MBFImage read(InputStream stream) throws IOException {
            return ImageUtilities.readMBF(stream);
        }

        public boolean canRead(InputStream stream, String name) {
            try {
                ByteSourceInputStream src = new ByteSourceInputStream(stream, name);
                return Sanselan.guessFormat((ByteSource)src) != ImageFormat.IMAGE_FORMAT_UNKNOWN;
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    public static final float[] BYTE_TO_FLOAT_LUT = new float[256];

    private ImageUtilities() {
    }

    public static FImage[] getNormalisedColourPlanes(BufferedImage bimg) {
        FImage[] images = new FImage[3];
        BufferedImage workingImage = ImageUtilities.createWorkingImage(bimg);
        int[] data = workingImage.getRGB(0, 0, workingImage.getWidth(), workingImage.getHeight(), null, 0, workingImage.getWidth());
        images[0] = new FImage(data, bimg.getWidth(), bimg.getHeight(), ARGBPlane.RED);
        images[1] = new FImage(data, bimg.getWidth(), bimg.getHeight(), ARGBPlane.GREEN);
        images[2] = new FImage(data, bimg.getWidth(), bimg.getHeight(), ARGBPlane.BLUE);
        for (int r = 0; r < images[0].height; ++r) {
            for (int c = 0; c < images[0].width; ++c) {
                float norm = (float)Math.sqrt(images[0].pixels[r][c] * images[0].pixels[r][c] + images[1].pixels[r][c] * images[1].pixels[r][c] + images[2].pixels[r][c] * images[2].pixels[r][c]);
                if (norm == 0.0f && images[0].pixels[r][c] == 0.0f) {
                    float[] fArray = images[0].pixels[r];
                    int n = c;
                    fArray[n] = (float)((double)fArray[n] / (1.0 / Math.sqrt(3.0)));
                } else {
                    float[] fArray = images[0].pixels[r];
                    int n = c;
                    fArray[n] = fArray[n] / norm;
                }
                if (norm == 0.0f && images[1].pixels[r][c] == 0.0f) {
                    float[] fArray = images[1].pixels[r];
                    int n = c;
                    fArray[n] = (float)((double)fArray[n] / (1.0 / Math.sqrt(3.0)));
                } else {
                    float[] fArray = images[1].pixels[r];
                    int n = c;
                    fArray[n] = fArray[n] / norm;
                }
                if (norm == 0.0f && images[2].pixels[r][c] == 0.0f) {
                    float[] fArray = images[2].pixels[r];
                    int n = c;
                    fArray[n] = (float)((double)fArray[n] / (1.0 / Math.sqrt(3.0)));
                    continue;
                }
                float[] fArray = images[2].pixels[r];
                int n = c;
                fArray[n] = fArray[n] / norm;
            }
        }
        return images;
    }

    public static BufferedImage createWorkingImage(BufferedImage bimg) {
        BufferedImage workingImage;
        if (bimg.getType() == 2) {
            workingImage = bimg;
        } else {
            workingImage = new BufferedImage(bimg.getWidth(), bimg.getHeight(), 2);
            Graphics2D g2d = workingImage.createGraphics();
            g2d.drawImage(bimg, null, 0, 0);
        }
        return workingImage;
    }

    public static void write(Image<?, ?> image, String formatName, File output) throws IOException {
        ImageIO.write((RenderedImage)ImageUtilities.createBufferedImageForDisplay(image), formatName, output);
    }

    public static void write(Image<?, ?> image, String formatName, OutputStream output) throws IOException {
        ImageIO.write((RenderedImage)ImageUtilities.createBufferedImageForDisplay(image), formatName, output);
    }

    public static void write(Image<?, ?> image, String formatName, ImageOutputStream output) throws IOException {
        ImageIO.write((RenderedImage)ImageUtilities.createBufferedImageForDisplay(image), formatName, output);
    }

    public static void write(Image<?, ?> image, File output) throws IOException {
        String name = output.getName();
        String format = name.substring(name.lastIndexOf(".") + 1);
        format = format.toLowerCase().trim();
        ImageIO.write((RenderedImage)ImageUtilities.createBufferedImageForDisplay(image), format, output);
    }

    public static FImage createFImage(BufferedImage image) {
        BufferedImage bimg = ImageUtilities.createWorkingImage(image);
        int[] data = bimg.getRGB(0, 0, bimg.getWidth(), bimg.getHeight(), null, 0, bimg.getWidth());
        return new FImage(data, bimg.getWidth(), bimg.getHeight());
    }

    public static MBFImage createMBFImage(BufferedImage image, boolean alpha) {
        BufferedImage bimg = ImageUtilities.createWorkingImage(image);
        int[] data = bimg.getRGB(0, 0, bimg.getWidth(), bimg.getHeight(), null, 0, bimg.getWidth());
        return new MBFImage(data, bimg.getWidth(), bimg.getHeight(), alpha);
    }

    public static FImage readF(File input) throws IOException {
        return ImageUtilities.createFImage(ExtendedImageIO.read(input));
    }

    public static FImage readF(InputStream input) throws IOException {
        return ImageUtilities.createFImage(ExtendedImageIO.read(input));
    }

    public static FImage readF(URL input) throws IOException {
        return ImageUtilities.createFImage(ExtendedImageIO.read(input));
    }

    public static MBFImage readMBF(File input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), false);
    }

    public static MBFImage readMBF(InputStream input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), false);
    }

    public static MBFImage readMBF(URL input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), false);
    }

    public static MBFImage readMBFAlpha(File input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), true);
    }

    public static MBFImage readMBFAlpha(InputStream input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), true);
    }

    public static MBFImage readMBFAlpha(URL input) throws IOException {
        return ImageUtilities.createMBFImage(ExtendedImageIO.read(input), true);
    }

    protected static boolean checkSameSize(Image<?, ?> ... images) {
        if (images == null || images.length == 0) {
            return true;
        }
        Image<?, ?> image = images[0];
        int w = image.getWidth();
        int h = image.getHeight();
        return ImageUtilities.checkSize(h, w, images);
    }

    protected static boolean checkSize(int h, int w, Image<?, ?> ... images) {
        for (Image<?, ?> image : images) {
            if (image.getHeight() == h && image.getWidth() == w) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkSize(int h, int w, Iterable<? extends Image<?, ?>> images) {
        for (Image<?, ?> image : images) {
            if (image.getHeight() == h && image.getWidth() == w) continue;
            return false;
        }
        return true;
    }

    protected static int pnmReadHeader(byte[] data, Map<String, Integer> headerData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        int count = 0;
        int bytesRead = 0;
        while (count < 4) {
            String tok;
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens() && !(tok = st.nextToken()).startsWith("#")) {
                switch (count) {
                    case 0: {
                        headerData.put("magic", Integer.decode(tok.substring(1)));
                        break;
                    }
                    case 1: {
                        headerData.put("width", Integer.decode(tok));
                        break;
                    }
                    case 2: {
                        headerData.put("height", Integer.decode(tok));
                        break;
                    }
                    case 3: {
                        headerData.put("maxval", Integer.decode(tok));
                    }
                }
                ++count;
            }
            bytesRead += line.length() + 1;
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getBytes(File file) throws IOException {
        try (FileInputStream is = null;){
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    protected static byte[] getBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        while (stream.read(b) > 0) {
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static BufferedImage createBufferedImage(Image<?, ?> img) {
        return ImageUtilities.createBufferedImage(img, null);
    }

    public static BufferedImage createBufferedImage(Image<?, ?> img, BufferedImage bimg) {
        if (bimg == null || bimg.getWidth() != img.getWidth() || bimg.getHeight() != img.getHeight() || bimg.getType() != 2) {
            bimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        }
        bimg.setRGB(0, 0, img.getWidth(), img.getHeight(), img.toPackedARGBPixels(), 0, img.getWidth());
        return bimg;
    }

    public static BufferedImage createBufferedImageForDisplay(Image<?, ?> img) {
        if (img instanceof MBFImage) {
            return ImageUtilities.createBufferedImageForDisplay((MBFImage)img);
        }
        if (img instanceof FImage) {
            return ImageUtilities.createBufferedImage((FImage)img);
        }
        return ImageUtilities.createBufferedImage(img);
    }

    public static BufferedImage createBufferedImageForDisplay(Image<?, ?> img, BufferedImage bimg) {
        if (img instanceof MBFImage) {
            return ImageUtilities.createBufferedImageForDisplay((MBFImage)img, bimg);
        }
        if (img instanceof FImage) {
            return ImageUtilities.createBufferedImage((FImage)img, bimg);
        }
        return ImageUtilities.createBufferedImage(img, bimg);
    }

    public static BufferedImage createBufferedImageForDisplay(MBFImage img) {
        return ImageUtilities.createBufferedImageForDisplay(img, null);
    }

    public static BufferedImage createBufferedImageForDisplay(MBFImage img, BufferedImage ret) {
        if (img.colourSpace != ColourSpace.RGB) {
            return ImageUtilities.createBufferedImage(img, ret);
        }
        int width = img.getWidth();
        int height = img.getHeight();
        if (ret == null || ret.getWidth() != width || ret.getHeight() != height || ret.getType() != 5) {
            ret = new BufferedImage(width, height, 5);
        }
        WritableRaster raster = ret.getRaster();
        float[][] r = ((FImage)img.getBand((int)0)).pixels;
        float[][] g = ((FImage)img.getBand((int)1)).pixels;
        float[][] b = ((FImage)img.getBand((int)2)).pixels;
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        DataBufferByte db = (DataBufferByte)raster.getDataBuffer();
        int scanlineStride = sm.getScanlineStride();
        int pixelStride = sm.getPixelStride();
        byte[] data = db.getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y * scanlineStride + x * pixelStride + 2] = (byte)Math.max(0, Math.min(255, (int)(r[y][x] * 255.0f)));
                data[y * scanlineStride + x * pixelStride + 1] = (byte)Math.max(0, Math.min(255, (int)(g[y][x] * 255.0f)));
                data[y * scanlineStride + x * pixelStride] = (byte)Math.max(0, Math.min(255, (int)(b[y][x] * 255.0f)));
            }
        }
        return ret;
    }

    public static BufferedImage createBufferedImage(FImage img) {
        return ImageUtilities.createBufferedImage(img, null);
    }

    public static BufferedImage createBufferedImage(FImage img, BufferedImage ret) {
        int width = img.getWidth();
        int height = img.getHeight();
        if (ret == null || ret.getWidth() != width || ret.getHeight() != height || ret.getType() != 10) {
            ret = new BufferedImage(width, height, 10);
        }
        WritableRaster raster = ret.getRaster();
        float[][] p = img.pixels;
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        DataBufferByte db = (DataBufferByte)raster.getDataBuffer();
        int scanlineStride = sm.getScanlineStride();
        int pixelStride = sm.getPixelStride();
        byte[] data = db.getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y * scanlineStride + x * pixelStride] = (byte)Math.max(0, Math.min(255, (int)(p[y][x] * 255.0f)));
            }
        }
        return ret;
    }

    public static void write(Image<?, ?> img, String formatName, DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageUtilities.write(img, formatName, baos);
        out.writeInt(baos.size());
        out.write(baos.toByteArray());
    }

    public static FImage readF(DataInput in) throws IOException {
        int sz = in.readInt();
        byte[] bytes = new byte[sz];
        in.readFully(bytes);
        return ImageUtilities.readF(new ByteArrayInputStream(bytes));
    }

    public static <I extends Image<?, I>> I assignBufferedImage(BufferedImage img, I oiImage) {
        BufferedImage bimg = ImageUtilities.createWorkingImage(img);
        int[] data = bimg.getRGB(0, 0, bimg.getWidth(), bimg.getHeight(), null, 0, bimg.getWidth());
        return oiImage.internalAssign(data, bimg.getWidth(), bimg.getHeight());
    }

    public static float[] alphaCompositePixel(float[] p1, float[] p2) {
        float thisR = p1[0];
        float thisG = p1[1];
        float thisB = p1[2];
        float thisA = 1.0f;
        if (p1.length == 4) {
            thisA = p1[3];
        }
        float thatA = 1.0f;
        if (p2.length == 4) {
            thatA = p2[3];
        }
        float thatR = p2[0];
        float thatG = p2[1];
        float thatB = p2[2];
        float a = thatA + thisA * (1.0f - thatA);
        a = a > 1.0f ? 1.0f : a;
        float r = thatR * thatA + thisR * thisA * (1.0f - thatA);
        r = r > 1.0f ? 1.0f : r;
        float g = thatG * thatA + thisG * thisA * (1.0f - thatA);
        g = g > 1.0f ? 1.0f : g;
        float b = thatB * thatA + thisB * thisA * (1.0f - thatA);
        b = b > 1.0f ? 1.0f : b;
        p1[0] = r;
        p1[1] = g;
        p1[2] = b;
        if (p1.length == 4) {
            p1[3] = a;
        }
        return p1;
    }

    public static float[] alphaCompositePixel(float[] out, float thisR, float thisG, float thisB, float thisA, float thatR, float thatG, float thatB, float thatA) {
        float a = thatA + thisA * (1.0f - thatA);
        a = a > 1.0f ? 1.0f : a;
        float r = thatR * thatA + thisR * thisA * (1.0f - thatA);
        r = r > 1.0f ? 1.0f : r;
        float g = thatG * thatA + thisG * thisA * (1.0f - thatA);
        g = g > 1.0f ? 1.0f : g;
        float b = thatB * thatA + thisB * thisA * (1.0f - thatA);
        b = b > 1.0f ? 1.0f : b;
        out[0] = r;
        out[1] = g;
        out[2] = b;
        out[3] = a;
        return out;
    }

    public static float[] alphaCompositePixel(Float[] p1, Float[] p2) {
        float[] p1p = new float[p1.length];
        for (int b = 0; b < p1.length; ++b) {
            p1p[b] = p1[b].floatValue();
        }
        float[] p2p = new float[p2.length];
        for (int b = 0; b < p2.length; ++b) {
            p2p[b] = p2[b].floatValue();
        }
        return ImageUtilities.alphaCompositePixel(p1p, p2p);
    }

    public static boolean isWriteFormatSupported(String fmt) {
        return ArrayUtils.contains((Object[])ImageIO.getWriterFormatNames(), (Object)fmt);
    }

    public static boolean isWriteFormatSupported(File file) {
        String name = file.getName();
        String format = name.substring(name.lastIndexOf(".") + 1);
        format = format.toLowerCase().trim();
        return ArrayUtils.contains((Object[])ImageIO.getWriterFormatNames(), (Object)format);
    }

    static {
        for (int i = 0; i < BYTE_TO_FLOAT_LUT.length; ++i) {
            ImageUtilities.BYTE_TO_FLOAT_LUT[i] = (float)i / 255.0f;
        }
    }
}

