/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import org.nlogo.core.View;
import org.nlogo.core.WorldDimensions;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u0001Y!)\u0011\b\u0001C\u0001u!)1\t\u0001C\u0001\t\nYqk\u001c:mI2{\u0017\rZ3s\u0015\tA\u0011\"A\u0005x_J\\7\u000f]1dK*\u0011!bC\u0001\u0006]2|wm\u001c\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u00059\u0011\u0001\u00027pC\u0012$2a\u0007\u0010'!\t\u0001B$\u0003\u0002\u001e#\t!QK\\5u\u0011\u0015y\"\u00011\u0001!\u0003\u00111\u0018.Z<\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rJ\u0011\u0001B2pe\u0016L!!\n\u0012\u0003\tYKWm\u001e\u0005\u0006O\t\u0001\r\u0001K\u0001\u000fo>\u0014H\u000eZ%oi\u0016\u0014h-Y2f!\tA\u0012&\u0003\u0002+\u000f\t!rk\u001c:mI2{\u0017\rZ3s\u0013:$XM\u001d4bG\u0016\f\u0001bZ3u/&$G\u000f\u001b\u000b\u0005[A\u0012t\u0007\u0005\u0002\u0011]%\u0011q&\u0005\u0002\u0004\u0013:$\b\"B\u0019\u0004\u0001\u0004A\u0013!B<pe2$\u0007\"B\u001a\u0004\u0001\u0004!\u0014!\u00013\u0011\u0005\u0005*\u0014B\u0001\u001c#\u0005=9vN\u001d7e\t&lWM\\:j_:\u001c\b\"\u0002\u001d\u0004\u0001\u0004\u0001\u0013!\u0001<\u0002\u0013\u001d,G\u000fS3jO\"$H#B\u0017<yu\u0012\u0005\"B\u0019\u0005\u0001\u0004A\u0003\"B\u001a\u0005\u0001\u0004!\u0004\"\u0002 \u0005\u0001\u0004y\u0014!\u00039bi\u000eD7+\u001b>f!\t\u0001\u0002)\u0003\u0002B#\t1Ai\\;cY\u0016DQ\u0001\u000f\u0003A\u0002\u0001\nq\"\u00193kkN$\b+\u0019;dQNK'0\u001a\u000b\u0004\u007f\u00153\u0005\"B\u0019\u0006\u0001\u0004A\u0003\"B\u001a\u0006\u0001\u0004!\u0004")
public class WorldLoader {
    public void load(View view2, WorldLoaderInterface worldInterface) {
        WorldDimensions d = view2.dimensions();
        String label = (String)view2.tickCounterLabel().getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> "");
        worldInterface.tickCounterLabel(label);
        worldInterface.showTickCounter(view2.showTickCounter());
        int width = this.getWidth(worldInterface, d, view2);
        double adjustedPatchSize = this.adjustPatchSize(worldInterface, d);
        int height = this.getHeight(worldInterface, d, adjustedPatchSize, view2);
        worldInterface.setDimensions(d, adjustedPatchSize);
        worldInterface.clearTurtles();
        worldInterface.fontSize(view2.fontSize());
        worldInterface.changeTopology(d.wrappingAllowedInX(), d.wrappingAllowedInY());
        worldInterface.updateMode(view2.updateMode());
        worldInterface.frameRate(view2.frameRate());
        worldInterface.setSize(width, height);
    }

    public int getWidth(WorldLoaderInterface world, WorldDimensions d, View v) {
        int widgetWidth = world.calculateWidth(d.width(), d.patchSize());
        int minWidth = world.getMinimumWidth();
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(widgetWidth), minWidth);
    }

    public int getHeight(WorldLoaderInterface world, WorldDimensions d, double patchSize, View v) {
        return world.calculateHeight(d.height(), patchSize);
    }

    public double adjustPatchSize(WorldLoaderInterface world, WorldDimensions d) {
        int minWidth;
        int widgetWidth = world.calculateWidth(d.width(), d.patchSize());
        if (widgetWidth < (minWidth = world.getMinimumWidth())) {
            return world.computePatchSize(minWidth - world.insetWidth(), d.width());
        }
        return d.patchSize();
    }
}

