/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import org.nlogo.api.World;
import org.nlogo.gl.render.TextureUtils;

class TextureRenderer {
    int texture = 0;
    int textureSize = 0;
    boolean newTexture = false;
    byte[][] tiles = null;
    final World world;

    TextureRenderer(World world) {
        this.world = world;
    }

    void deleteTexture() {
        this.textureSize = 0;
    }

    void renderTextureTiles(GL2 gl, int width, int height, int textureSize, int[] colors, boolean dirty) {
        float scale = 0.3f;
        gl.glPushMatrix();
        float wrapXLine = 0.0f;
        float wrapYLine = 0.0f;
        boolean wrapXLeft = true;
        boolean wrapYDown = true;
        double worldWidth = this.world.worldWidth();
        double worldHeight = this.world.worldHeight();
        double oxcor = this.world.followOffsetX();
        double oycor = this.world.followOffsetY();
        if (oxcor + worldWidth < worldWidth) {
            wrapXLine = (float)(oxcor + worldWidth);
            wrapXLeft = false;
        } else if (oxcor > 0.0) {
            wrapXLine = (float)oxcor;
        }
        wrapXLine *= (float)width / (float)worldWidth;
        if (oycor + worldHeight < worldHeight) {
            wrapYLine = (float)(oycor + worldHeight);
            wrapYDown = false;
        } else if (oycor > 0.0) {
            wrapYLine = (float)oycor;
        }
        wrapYLine *= (float)height / (float)worldHeight;
        gl.glTranslatef((float)(-oxcor * (double)scale), (float)(-oycor * (double)scale), 0.0f);
        float tw = Math.min(width, textureSize);
        float th = Math.min(height, textureSize);
        gl.glScalef(tw * ((float)this.world.worldWidth() / (float)width), th * ((float)this.world.worldHeight() / (float)height), 1.0f);
        gl.glTranslatef(-((float)width - tw) * scale / (2.0f * tw), ((float)height - th) * scale / (2.0f * th), 0.0f);
        int i = 0;
        int tileWidth = Math.min(width, textureSize);
        int tileHeight = Math.min(height, textureSize);
        int yOffset = height;
        while (yOffset > 0) {
            gl.glPushMatrix();
            int xOffset = 0;
            while (xOffset < width) {
                tileWidth = Math.min(width - xOffset, textureSize);
                tileHeight = Math.min(yOffset, textureSize);
                if (dirty || this.tiles.length > 1) {
                    this.tiles[i] = TextureUtils.reuseTexture(gl, tileWidth, tileHeight, xOffset, height - yOffset, width, colors, this.tiles[i]);
                }
                gl.glPushMatrix();
                gl.glScalef((float)tileWidth / tw, (float)tileHeight / th, 1.0f);
                int horzPieces = 1;
                float horzSplit = 1.0f;
                int vertPieces = 1;
                float vertSplit = 1.0f;
                if ((float)xOffset < wrapXLine && (float)(xOffset + tileWidth) > wrapXLine) {
                    horzPieces = 2;
                    horzSplit = (wrapXLine - (float)xOffset) / (float)tileWidth;
                }
                if ((float)yOffset > wrapYLine && (float)(yOffset - tileHeight) < wrapYLine) {
                    vertPieces = 2;
                    vertSplit = ((float)yOffset - wrapYLine) / (float)tileHeight;
                }
                for (int h = 0; h < horzPieces; ++h) {
                    gl.glPushMatrix();
                    float horzPieceSize = h == 0 ? horzSplit : 1.0f - horzSplit;
                    float horzPieceCenter = horzPieceSize / 2.0f + (h == 0 ? 0.0f : horzSplit);
                    gl.glTranslatef(scale * (horzPieceCenter - 0.5f), 0.0f, 0.0f);
                    if ((float)xOffset + (float)tileWidth * horzPieceCenter < wrapXLine && wrapXLeft) {
                        gl.glTranslatef((float)width * scale / (float)tileWidth, 0.0f, 0.0f);
                    } else if ((float)xOffset + (float)tileWidth * horzPieceCenter > wrapXLine && !wrapXLeft) {
                        gl.glTranslatef(-((float)width * scale / (float)tileWidth), 0.0f, 0.0f);
                    }
                    for (int v = 0; v < vertPieces; ++v) {
                        gl.glPushMatrix();
                        float vertPieceSize = v == 0 ? vertSplit : 1.0f - vertSplit;
                        float vertPieceCenter = vertPieceSize / 2.0f + (v == 0 ? 0.0f : vertSplit);
                        gl.glTranslatef(0.0f, scale * (1.0f - vertPieceCenter - 0.5f), 0.0f);
                        if ((float)yOffset - (float)tileHeight * vertPieceCenter < wrapYLine && wrapYDown) {
                            gl.glTranslatef(0.0f, (float)height * scale / (float)tileHeight, 0.0f);
                        } else if ((float)yOffset - (float)tileHeight * vertPieceCenter > wrapYLine && !wrapYDown) {
                            gl.glTranslatef(0.0f, -((float)height * scale / (float)tileHeight), 0.0f);
                        }
                        TextureUtils.renderInPlane(gl, horzPieceSize, vertPieceSize, 1.0f, horzPieceSize * (float)tileWidth, vertPieceSize * (float)tileHeight, textureSize, h == 0 ? 0.0f : horzSplit * (float)tileWidth, v == 0 ? 0.0f : vertSplit * (float)tileHeight);
                        gl.glPopMatrix();
                    }
                    gl.glPopMatrix();
                }
                gl.glPopMatrix();
                tileWidth = Math.min(width - (xOffset += textureSize), textureSize);
                gl.glTranslatef(scale * (1.0f - ((float)textureSize - (float)tileWidth) / (float)textureSize / 2.0f), 0.0f, 0.0f);
                ++i;
            }
            gl.glPopMatrix();
            tileHeight = Math.min(yOffset -= textureSize, textureSize);
            gl.glTranslatef(0.0f, -(scale * (1.0f - ((float)textureSize - (float)tileHeight) / (float)textureSize / 2.0f)), 0.0f);
        }
        gl.glPopMatrix();
    }
}

