/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGCircle;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Circle
extends Shape {
    private final Ellipse2D shape = new Ellipse2D();
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private final DoubleProperty radius = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Circle.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Circle.this;
        }

        @Override
        public String getName() {
            return "radius";
        }
    };

    public Circle(double radius) {
        this.setRadius(radius);
    }

    public Circle(double radius, Paint fill) {
        this.setRadius(radius);
        this.setFill(fill);
    }

    public Circle() {
    }

    public Circle(double centerX, double centerY, double radius) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
        this.setRadius(radius);
    }

    public Circle(double centerX, double centerY, double radius, Paint fill) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
        this.setRadius(radius);
        this.setFill(fill);
    }

    public final void setCenterX(double value) {
        if (this.centerX != null || value != 0.0) {
            this.centerXProperty().set(value);
        }
    }

    public final double getCenterX() {
        return this.centerX == null ? 0.0 : this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Circle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Circle.this;
                }

                @Override
                public String getName() {
                    return "centerX";
                }
            };
        }
        return this.centerX;
    }

    public final void setCenterY(double value) {
        if (this.centerY != null || value != 0.0) {
            this.centerYProperty().set(value);
        }
    }

    public final double getCenterY() {
        return this.centerY == null ? 0.0 : this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Circle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Circle.this;
                }

                @Override
                public String getName() {
                    return "centerY";
                }
            };
        }
        return this.centerY;
    }

    public final void setRadius(double value) {
        this.radius.set(value);
    }

    public final double getRadius() {
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        return this.radius;
    }

    @Override
    StrokeLineJoin convertLineJoin(StrokeLineJoin t) {
        return StrokeLineJoin.BEVEL;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGCircle();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.impl_mode == NGShape.Mode.EMPTY) {
            return bounds.makeEmpty();
        }
        double cX = this.getCenterX();
        double cY = this.getCenterY();
        if ((tx.getType() & 0xFFFFFFE6) == 0) {
            double tCX = cX * tx.getMxx() + cY * tx.getMxy() + tx.getMxt();
            double tCY = cX * tx.getMyx() + cY * tx.getMyy() + tx.getMyt();
            double r = this.getRadius();
            if (this.impl_mode != NGShape.Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
                double upad = this.getStrokeWidth();
                if (this.getStrokeType() == StrokeType.CENTERED) {
                    upad /= 2.0;
                }
                r += upad;
            }
            return bounds.deriveWithNewBounds((float)(tCX - r), (float)(tCY - r), 0.0f, (float)(tCX + r), (float)(tCY + r), 0.0f);
        }
        if ((tx.getType() & 0xFFFFFFB8) == 0) {
            double width;
            double r = this.getRadius();
            double x = this.getCenterX() - r;
            double y = this.getCenterY() - r;
            double height = width = 2.0 * r;
            double upad = this.impl_mode == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE ? 0.0 : this.getStrokeWidth();
            return this.computeBounds(bounds, tx, upad, 0.0, x, y, width, height);
        }
        return this.computeShapeBounds(bounds, tx, this.impl_configShape());
    }

    @Override
    @Deprecated
    public Ellipse2D impl_configShape() {
        double r = this.getRadius();
        this.shape.setFrame((float)(this.getCenterX() - r), (float)(this.getCenterY() - r), (float)(r * 2.0), (float)(r * 2.0));
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            NGCircle peer = (NGCircle)this.impl_getPeer();
            peer.updateCircle((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadius());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Circle[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("centerX=").append(this.getCenterX());
        sb.append(", centerY=").append(this.getCenterY());
        sb.append(", radius=").append(this.getRadius());
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }
}

